@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetControlPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getControlPolicies.
 * @property aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
 * @property aclUuid The unique ID of the access control policy.
 * @property description The description of the access control policy.
 * @property destination The destination address defined in the access control policy.
 * @property direction The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
 * @property ipVersion The IP version of the address in the access control policy.
 * @property lang The language of the content within the response. Valid values: `en`, `zh`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property proto The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
 * @property source The source address in the access control policy.
 */
public data class GetControlPoliciesPlainArgs(
    public val aclAction: String? = null,
    public val aclUuid: String? = null,
    public val description: String? = null,
    public val destination: String? = null,
    public val direction: String,
    public val ipVersion: String? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val proto: String? = null,
    public val source: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetControlPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetControlPoliciesPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetControlPoliciesPlainArgs.builder()
            .aclAction(aclAction?.let({ args0 -> args0 }))
            .aclUuid(aclUuid?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .destination(destination?.let({ args0 -> args0 }))
            .direction(direction.let({ args0 -> args0 }))
            .ipVersion(ipVersion?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .proto(proto?.let({ args0 -> args0 }))
            .source(source?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetControlPoliciesPlainArgsBuilder internal constructor() {
    private var aclAction: String? = null

    private var aclUuid: String? = null

    private var description: String? = null

    private var destination: String? = null

    private var direction: String? = null

    private var ipVersion: String? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var proto: String? = null

    private var source: String? = null

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("slruvvcjrnkplmhh")
    public suspend fun aclAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclAction = mapped
    }

    /**
     * @param value The unique ID of the access control policy.
     */
    @JvmName("bwcmlnfxmgcntiom")
    public suspend fun aclUuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclUuid = mapped
    }

    /**
     * @param value The description of the access control policy.
     */
    @JvmName("eraeeoroesrjdkts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The destination address defined in the access control policy.
     */
    @JvmName("tbxdmjrueswlumwm")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destination = mapped
    }

    /**
     * @param value The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
     */
    @JvmName("ovkwfcsyfuvtbofx")
    public suspend fun direction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The IP version of the address in the access control policy.
     */
    @JvmName("gfywhwuaokdmbpen")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipVersion = mapped
    }

    /**
     * @param value The language of the content within the response. Valid values: `en`, `zh`.
     */
    @JvmName("ifjwbxbeswywedcq")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oitxpofdaasogsgm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
     */
    @JvmName("ipvjqwhybnraclgm")
    public suspend fun proto(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.proto = mapped
    }

    /**
     * @param value The source address in the access control policy.
     */
    @JvmName("oluldrufxoajbqit")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.source = mapped
    }

    internal fun build(): GetControlPoliciesPlainArgs = GetControlPoliciesPlainArgs(
        aclAction = aclAction,
        aclUuid = aclUuid,
        description = description,
        destination = destination,
        direction = direction ?: throw PulumiNullFieldException("direction"),
        ipVersion = ipVersion,
        lang = lang,
        outputFile = outputFile,
        proto = proto,
        source = source,
    )
}
