@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetInstanceMembersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceMembers.
 * @property currentPage
 * @property ids A list of Instance Member IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetInstanceMembersPlainArgs(
    public val currentPage: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetInstanceMembersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetInstanceMembersPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetInstanceMembersPlainArgs.builder()
            .currentPage(currentPage?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceMembersPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceMembersPlainArgsBuilder internal constructor() {
    private var currentPage: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value
     */
    @JvmName("sxmylahsnfqjxjyc")
    public suspend fun currentPage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.currentPage = mapped
    }

    /**
     * @param value A list of Instance Member IDs.
     */
    @JvmName("rqkgptpiwledhcam")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance Member IDs.
     */
    @JvmName("dbhobckvgxhsnqpf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qgwcsngdoqlhjuox")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("vcgyonclqbyxxoth")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ikssejhcmbavweyi")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetInstanceMembersPlainArgs = GetInstanceMembersPlainArgs(
        currentPage = currentPage,
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
