@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallCensPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcFirewallCens.
 * @property cenId The ID of the CEN instance.
 * @property ids A list of Vpc Firewall Cen IDs.
 * @property lang The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
 * @property memberUid The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status Firewall switch status
 * @property vpcFirewallId VPC firewall ID
 * @property vpcFirewallName The name of the VPC firewall instance.
 */
public data class GetVpcFirewallCensPlainArgs(
    public val cenId: String? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val networkInstanceId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val vpcFirewallId: String? = null,
    public val vpcFirewallName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallCensPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallCensPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallCensPlainArgs.builder()
            .cenId(cenId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .memberUid(memberUid?.let({ args0 -> args0 }))
            .networkInstanceId(networkInstanceId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcFirewallId(vpcFirewallId?.let({ args0 -> args0 }))
            .vpcFirewallName(vpcFirewallName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcFirewallCensPlainArgs].
 */
@PulumiTagMarker
public class GetVpcFirewallCensPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var memberUid: String? = null

    private var networkInstanceId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    private var vpcFirewallId: String? = null

    private var vpcFirewallName: String? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("wcwhenbwvivbbbmb")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of Vpc Firewall Cen IDs.
     */
    @JvmName("dvfjokgooefddktd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Firewall Cen IDs.
     */
    @JvmName("lklmmcnrobfwhifa")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
     */
    @JvmName("nlphttshdwbgwctr")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
     */
    @JvmName("fmsbckxqgntqovad")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memberUid = mapped
    }

    /**
     * @param value The ID of the VPC instance that created the VPC firewall.
     */
    @JvmName("ovjovxsuvwphxlpi")
    public suspend fun networkInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInstanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pcnbacvgqvyngvhe")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("vpyrhqdjkarqbpmb")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("jphdmxekhesdanis")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Firewall switch status
     */
    @JvmName("heinwxgbqkqglxat")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value VPC firewall ID
     */
    @JvmName("awghkdvbhowoblfd")
    public suspend fun vpcFirewallId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcFirewallId = mapped
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("ibydhbcscvbxpmwx")
    public suspend fun vpcFirewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcFirewallName = mapped
    }

    internal fun build(): GetVpcFirewallCensPlainArgs = GetVpcFirewallCensPlainArgs(
        cenId = cenId,
        ids = ids,
        lang = lang,
        memberUid = memberUid,
        networkInstanceId = networkInstanceId,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
        vpcFirewallId = vpcFirewallId,
        vpcFirewallName = vpcFirewallName,
    )
}
