@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallControlPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcFirewallControlPolicies.
 * @property aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
 * @property aclUuid Access control over VPC firewalls strategy unique identifier.
 * @property description Access control over VPC firewalls description of the strategy information.
 * @property destination Access control over VPC firewalls strategy the destination address in.
 * @property ids A list of Vpc Firewall Control Policy IDs.
 * @property lang The language of the content within the request and response. Valid values: `zh`, `en`.
 * @property memberUid The UID of the member account of the current Alibaba cloud account.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property proto Access control over VPC firewalls strategy access traffic of the protocol type.
 * @property release The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
 * - **true**: Enable access control policies
 * - **false**: does not enable access control policies.
 * @property source Access control over VPC firewalls strategy in the source address.
 * @property vpcFirewallId The ID of the VPC firewall instance. Value:
 * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
 * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
 */
public data class GetVpcFirewallControlPoliciesPlainArgs(
    public val aclAction: String? = null,
    public val aclUuid: String? = null,
    public val description: String? = null,
    public val destination: String? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val proto: String? = null,
    public val release: Boolean? = null,
    public val source: String? = null,
    public val vpcFirewallId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallControlPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallControlPoliciesPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallControlPoliciesPlainArgs.builder()
            .aclAction(aclAction?.let({ args0 -> args0 }))
            .aclUuid(aclUuid?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .destination(destination?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .memberUid(memberUid?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .proto(proto?.let({ args0 -> args0 }))
            .release(release?.let({ args0 -> args0 }))
            .source(source?.let({ args0 -> args0 }))
            .vpcFirewallId(vpcFirewallId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcFirewallControlPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetVpcFirewallControlPoliciesPlainArgsBuilder internal constructor() {
    private var aclAction: String? = null

    private var aclUuid: String? = null

    private var description: String? = null

    private var destination: String? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var memberUid: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var proto: String? = null

    private var release: Boolean? = null

    private var source: String? = null

    private var vpcFirewallId: String? = null

    /**
     * @param value The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
     */
    @JvmName("phmnoxnvgvkilcyl")
    public suspend fun aclAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclAction = mapped
    }

    /**
     * @param value Access control over VPC firewalls strategy unique identifier.
     */
    @JvmName("jrlimvelqwjgwwjv")
    public suspend fun aclUuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclUuid = mapped
    }

    /**
     * @param value Access control over VPC firewalls description of the strategy information.
     */
    @JvmName("xcwwlrcgcojfpwyw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value Access control over VPC firewalls strategy the destination address in.
     */
    @JvmName("qmjfbodugslnttrp")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destination = mapped
    }

    /**
     * @param value A list of Vpc Firewall Control Policy IDs.
     */
    @JvmName("qoblhuhkcntxolag")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Firewall Control Policy IDs.
     */
    @JvmName("uyjxdmmwkptvhkuk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The language of the content within the request and response. Valid values: `zh`, `en`.
     */
    @JvmName("ojiktmvkevoblqmx")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value The UID of the member account of the current Alibaba cloud account.
     */
    @JvmName("dskhqcsrklkksomq")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memberUid = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rkdmyhbcbnnityeg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("cminushaegiuimej")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("sphlcfqwbpkjumom")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Access control over VPC firewalls strategy access traffic of the protocol type.
     */
    @JvmName("jjgrtvceqqdjonht")
    public suspend fun proto(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.proto = mapped
    }

    /**
     * @param value The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
     * - **true**: Enable access control policies
     * - **false**: does not enable access control policies.
     */
    @JvmName("wjgyooiglsytfgyb")
    public suspend fun release(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.release = mapped
    }

    /**
     * @param value Access control over VPC firewalls strategy in the source address.
     */
    @JvmName("rivbinbnqnxnxctb")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.source = mapped
    }

    /**
     * @param value The ID of the VPC firewall instance. Value:
     * - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
     * - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
     */
    @JvmName("bmndhdkwssortian")
    public suspend fun vpcFirewallId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpcFirewallId = mapped
    }

    internal fun build(): GetVpcFirewallControlPoliciesPlainArgs =
        GetVpcFirewallControlPoliciesPlainArgs(
            aclAction = aclAction,
            aclUuid = aclUuid,
            description = description,
            destination = destination,
            ids = ids,
            lang = lang,
            memberUid = memberUid,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            proto = proto,
            release = release,
            source = source,
            vpcFirewallId = vpcFirewallId ?: throw PulumiNullFieldException("vpcFirewallId"),
        )
}
