@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcFirewalls.
 * @property ids A list of Vpc Firewall IDs.
 * @property lang The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
 * @property memberUid The UID of the Alibaba Cloud member account.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property regionNo The region ID of the peer VPC.
 * @property status The status of the resource
 * @property vpcFirewallId The ID of the VPC firewall instance.
 * @property vpcFirewallName The name of the VPC firewall instance.
 * @property vpcId The ID of the peer VPC instance.
 */
public data class GetVpcFirewallsPlainArgs(
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val regionNo: String? = null,
    public val status: String? = null,
    public val vpcFirewallId: String? = null,
    public val vpcFirewallName: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallsPlainArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.GetVpcFirewallsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .memberUid(memberUid?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .regionNo(regionNo?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcFirewallId(vpcFirewallId?.let({ args0 -> args0 }))
            .vpcFirewallName(vpcFirewallName?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcFirewallsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcFirewallsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var lang: String? = null

    private var memberUid: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var regionNo: String? = null

    private var status: String? = null

    private var vpcFirewallId: String? = null

    private var vpcFirewallName: String? = null

    private var vpcId: String? = null

    /**
     * @param value A list of Vpc Firewall IDs.
     */
    @JvmName("beeylwatsyelaynu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Firewall IDs.
     */
    @JvmName("ykmdhtirtuuouclv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
     */
    @JvmName("vanirhkbmabxuira")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value The UID of the Alibaba Cloud member account.
     */
    @JvmName("eqdewmpnykynjune")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memberUid = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("nsxmlidlqtypuctp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("amcmphgntfxcprmr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The region ID of the peer VPC.
     */
    @JvmName("hstkietnirwjwpcp")
    public suspend fun regionNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regionNo = mapped
    }

    /**
     * @param value The status of the resource
     */
    @JvmName("acehueurousokhwk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the VPC firewall instance.
     */
    @JvmName("aeaplkmivfkdujqc")
    public suspend fun vpcFirewallId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcFirewallId = mapped
    }

    /**
     * @param value The name of the VPC firewall instance.
     */
    @JvmName("griyseftwwsrevid")
    public suspend fun vpcFirewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcFirewallName = mapped
    }

    /**
     * @param value The ID of the peer VPC instance.
     */
    @JvmName("ycilqmtlgsltixsv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetVpcFirewallsPlainArgs = GetVpcFirewallsPlainArgs(
        ids = ids,
        lang = lang,
        memberUid = memberUid,
        nameRegex = nameRegex,
        outputFile = outputFile,
        regionNo = regionNo,
        status = status,
        vpcFirewallId = vpcFirewallId,
        vpcFirewallName = vpcFirewallName,
        vpcId = vpcId,
    )
}
