@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.inputs

import com.pulumi.alicloud.cloudfirewall.inputs.NatFirewallNatRouteEntryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationCidr The destination network segment of the default route.
 * @property nexthopId The next hop address of the original NAT gateway.
 * @property nexthopType The network type of the next hop. Value: NatGateway : NAT Gateway.
 * @property routeTableId The route table where the default route of the NAT gateway is located.
 */
public data class NatFirewallNatRouteEntryListArgs(
    public val destinationCidr: Output<String>,
    public val nexthopId: Output<String>,
    public val nexthopType: Output<String>,
    public val routeTableId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cloudfirewall.inputs.NatFirewallNatRouteEntryListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudfirewall.inputs.NatFirewallNatRouteEntryListArgs =
        com.pulumi.alicloud.cloudfirewall.inputs.NatFirewallNatRouteEntryListArgs.builder()
            .destinationCidr(destinationCidr.applyValue({ args0 -> args0 }))
            .nexthopId(nexthopId.applyValue({ args0 -> args0 }))
            .nexthopType(nexthopType.applyValue({ args0 -> args0 }))
            .routeTableId(routeTableId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NatFirewallNatRouteEntryListArgs].
 */
@PulumiTagMarker
public class NatFirewallNatRouteEntryListArgsBuilder internal constructor() {
    private var destinationCidr: Output<String>? = null

    private var nexthopId: Output<String>? = null

    private var nexthopType: Output<String>? = null

    private var routeTableId: Output<String>? = null

    /**
     * @param value The destination network segment of the default route.
     */
    @JvmName("dboybciwmrwtpibg")
    public suspend fun destinationCidr(`value`: Output<String>) {
        this.destinationCidr = value
    }

    /**
     * @param value The next hop address of the original NAT gateway.
     */
    @JvmName("tjnrjfwsqmnfnqrk")
    public suspend fun nexthopId(`value`: Output<String>) {
        this.nexthopId = value
    }

    /**
     * @param value The network type of the next hop. Value: NatGateway : NAT Gateway.
     */
    @JvmName("tsgrwncymuulohbi")
    public suspend fun nexthopType(`value`: Output<String>) {
        this.nexthopType = value
    }

    /**
     * @param value The route table where the default route of the NAT gateway is located.
     */
    @JvmName("cyjhqbjwhgauamod")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The destination network segment of the default route.
     */
    @JvmName("yujhhwdoktfvaagu")
    public suspend fun destinationCidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationCidr = mapped
    }

    /**
     * @param value The next hop address of the original NAT gateway.
     */
    @JvmName("hxdbmapvvmolwujs")
    public suspend fun nexthopId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nexthopId = mapped
    }

    /**
     * @param value The network type of the next hop. Value: NatGateway : NAT Gateway.
     */
    @JvmName("gmgaamjosaxwiugr")
    public suspend fun nexthopType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nexthopType = mapped
    }

    /**
     * @param value The route table where the default route of the NAT gateway is located.
     */
    @JvmName("ymcirpwjwskukkat")
    public suspend fun routeTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    internal fun build(): NatFirewallNatRouteEntryListArgs = NatFirewallNatRouteEntryListArgs(
        destinationCidr = destinationCidr ?: throw PulumiNullFieldException("destinationCidr"),
        nexthopId = nexthopId ?: throw PulumiNullFieldException("nexthopId"),
        nexthopType = nexthopType ?: throw PulumiNullFieldException("nexthopType"),
        routeTableId = routeTableId ?: throw PulumiNullFieldException("routeTableId"),
    )
}
