@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tagKey The key of ECS tag that to be matched.
 * @property tagValue The value of ECS tag that to be matched.
 */
public data class AddressBookEcsTag(
    public val tagKey: String? = null,
    public val tagValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.AddressBookEcsTag): AddressBookEcsTag = AddressBookEcsTag(
            tagKey = javaType.tagKey().map({ args0 -> args0 }).orElse(null),
            tagValue = javaType.tagValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
