@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachmentId The connection ID of the network instance.
 * @property attachmentName The connection name of the network instance.
 * @property defendCidrLists The list of network segments protected by the VPC firewall.
 * @property eniLists List of elastic network cards.
 * @property manualVswitchId The ID of the vSwitch specified when the routing mode is manual mode.
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property networkInstanceName The name of the network instance.
 * @property networkInstanceType The type of the network instance. Value: **VPC * *.
 * @property ownerId The UID of the Alibaba Cloud account to which the VPC belongs.
 * @property regionNo The region ID of the VPC.
 * @property routeMode Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
 * @property supportManualMode Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
 * @property transitRouterId The ID of the CEN-TR instance.
 * @property transitRouterType The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
 * @property vpcCidrTableLists The VPC network segment list.
 * @property vpcId The ID of the VPC instance.
 * @property vpcName The instance name of the VPC.
 */
public data class FirewallVpcFirewallCenLocalVpc(
    public val attachmentId: String? = null,
    public val attachmentName: String? = null,
    public val defendCidrLists: List<String>? = null,
    public val eniLists: List<FirewallVpcFirewallCenLocalVpcEniList>? = null,
    public val manualVswitchId: String? = null,
    public val networkInstanceId: String,
    public val networkInstanceName: String? = null,
    public val networkInstanceType: String? = null,
    public val ownerId: String? = null,
    public val regionNo: String? = null,
    public val routeMode: String? = null,
    public val supportManualMode: String? = null,
    public val transitRouterId: String? = null,
    public val transitRouterType: String? = null,
    public val vpcCidrTableLists: List<FirewallVpcFirewallCenLocalVpcVpcCidrTableList>? = null,
    public val vpcId: String? = null,
    public val vpcName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.FirewallVpcFirewallCenLocalVpc): FirewallVpcFirewallCenLocalVpc = FirewallVpcFirewallCenLocalVpc(
            attachmentId = javaType.attachmentId().map({ args0 -> args0 }).orElse(null),
            attachmentName = javaType.attachmentName().map({ args0 -> args0 }).orElse(null),
            defendCidrLists = javaType.defendCidrLists().map({ args0 -> args0 }),
            eniLists = javaType.eniLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallCenLocalVpcEniList.Companion.toKotlin(args0)
                })
            }),
            manualVswitchId = javaType.manualVswitchId().map({ args0 -> args0 }).orElse(null),
            networkInstanceId = javaType.networkInstanceId(),
            networkInstanceName = javaType.networkInstanceName().map({ args0 -> args0 }).orElse(null),
            networkInstanceType = javaType.networkInstanceType().map({ args0 -> args0 }).orElse(null),
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
            regionNo = javaType.regionNo().map({ args0 -> args0 }).orElse(null),
            routeMode = javaType.routeMode().map({ args0 -> args0 }).orElse(null),
            supportManualMode = javaType.supportManualMode().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId().map({ args0 -> args0 }).orElse(null),
            transitRouterType = javaType.transitRouterType().map({ args0 -> args0 }).orElse(null),
            vpcCidrTableLists = javaType.vpcCidrTableLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableList.Companion.toKotlin(args0)
                })
            }),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vpcName = javaType.vpcName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
