@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eniId The ID of the instance of the ENI in the peer VPC.
 * @property eniPrivateIpAddress The private IP address of the elastic network card in the peer VPC.
 * @property peerVpcCidrTableLists The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
 * @property regionNo The region ID of the peer VPC.
 * @property routerInterfaceId The ID of the router interface in the peer VPC.
 * @property vpcId The ID of the peer VPC instance.
 * @property vpcName The instance name of the peer VPC.
 */
public data class FirewallVpcFirewallPeerVpc(
    public val eniId: String? = null,
    public val eniPrivateIpAddress: String? = null,
    public val peerVpcCidrTableLists: List<FirewallVpcFirewallPeerVpcPeerVpcCidrTableList>,
    public val regionNo: String,
    public val routerInterfaceId: String? = null,
    public val vpcId: String,
    public val vpcName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.FirewallVpcFirewallPeerVpc): FirewallVpcFirewallPeerVpc = FirewallVpcFirewallPeerVpc(
            eniId = javaType.eniId().map({ args0 -> args0 }).orElse(null),
            eniPrivateIpAddress = javaType.eniPrivateIpAddress().map({ args0 -> args0 }).orElse(null),
            peerVpcCidrTableLists = javaType.peerVpcCidrTableLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableList.Companion.toKotlin(args0)
                })
            }),
            regionNo = javaType.regionNo(),
            routerInterfaceId = javaType.routerInterfaceId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId(),
            vpcName = javaType.vpcName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
