@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addressLists The addresses in the Address Book.
 * @property autoAddTagEcs Whether you want to automatically add new matching tags of the ECS IP address to the Address Book.
 * @property description The description of the Address Book.
 * @property ecsTags The logical relation among the ECS tags that to be matchedh.
 * @property groupName The name of the Address Book.
 * @property groupType The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
 * **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
 * @property groupUuid The ID of the Address Book.
 * @property id The ID of the Address Book.
 * @property tagRelation One or more tags for the relationship between.
 */
public data class GetAddressBooksBook(
    public val addressLists: List<String>,
    public val autoAddTagEcs: Int,
    public val description: String,
    public val ecsTags: List<GetAddressBooksBookEcsTag>,
    public val groupName: String,
    public val groupType: String,
    public val groupUuid: String,
    public val id: String,
    public val tagRelation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetAddressBooksBook): GetAddressBooksBook = GetAddressBooksBook(
            addressLists = javaType.addressLists().map({ args0 -> args0 }),
            autoAddTagEcs = javaType.autoAddTagEcs(),
            description = javaType.description(),
            ecsTags = javaType.ecsTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetAddressBooksBookEcsTag.Companion.toKotlin(args0)
                })
            }),
            groupName = javaType.groupName(),
            groupType = javaType.groupType(),
            groupUuid = javaType.groupUuid(),
            id = javaType.id(),
            tagRelation = javaType.tagRelation(),
        )
    }
}
