@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclAction The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
 * @property aclUuid The unique ID of the access control policy.
 * @property applicationId The application ID in the access control policy.
 * @property applicationName The type of the application that the access control policy supports.
 * @property description The description of the access control policy.
 * @property destPort The destination port in the access control policy.
 * @property destPortGroup The name of the destination port address book in the access control policy.
 * @property destPortGroupPorts The ports in the destination port address book.
 * @property destPortType The type of the destination port in the access control policy.
 * @property destination The destination address defined in the access control policy.
 * @property destinationGroupCidrs The CIDR blocks in the destination address book.
 * @property destinationGroupType The type of the destination address book in the access control policy.
 * @property destinationType The type of the destination address in the access control policy.
 * @property direction The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
 * @property dnsResult The DNS resolution result.
 * @property dnsResultTime The timestamp of the DNS resolution result.
 * @property hitTimes The number of hits for the access control policy.
 * @property id The ID of the Control Policy. It formats as `<acl_uuid>:<direction>`.
 * @property order The priority of the access control policy.
 * @property proto The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
 * @property release Indicates whether the access control policy is enabled.
 * @property source The source address in the access control policy.
 * @property sourceGroupCidrs The CIDR blocks in the source address book.
 * @property sourceGroupType The type of the source address book in the access control policy.
 * @property sourceType The type of the source address in the access control policy.
 */
public data class GetControlPoliciesPolicy(
    public val aclAction: String,
    public val aclUuid: String,
    public val applicationId: String,
    public val applicationName: String,
    public val description: String,
    public val destPort: String,
    public val destPortGroup: String,
    public val destPortGroupPorts: List<String>,
    public val destPortType: String,
    public val destination: String,
    public val destinationGroupCidrs: List<String>,
    public val destinationGroupType: String,
    public val destinationType: String,
    public val direction: String,
    public val dnsResult: String,
    public val dnsResultTime: String,
    public val hitTimes: String,
    public val id: String,
    public val order: Int,
    public val proto: String,
    public val release: Boolean,
    public val source: String,
    public val sourceGroupCidrs: List<String>,
    public val sourceGroupType: String,
    public val sourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetControlPoliciesPolicy): GetControlPoliciesPolicy = GetControlPoliciesPolicy(
            aclAction = javaType.aclAction(),
            aclUuid = javaType.aclUuid(),
            applicationId = javaType.applicationId(),
            applicationName = javaType.applicationName(),
            description = javaType.description(),
            destPort = javaType.destPort(),
            destPortGroup = javaType.destPortGroup(),
            destPortGroupPorts = javaType.destPortGroupPorts().map({ args0 -> args0 }),
            destPortType = javaType.destPortType(),
            destination = javaType.destination(),
            destinationGroupCidrs = javaType.destinationGroupCidrs().map({ args0 -> args0 }),
            destinationGroupType = javaType.destinationGroupType(),
            destinationType = javaType.destinationType(),
            direction = javaType.direction(),
            dnsResult = javaType.dnsResult(),
            dnsResultTime = javaType.dnsResultTime(),
            hitTimes = javaType.hitTimes(),
            id = javaType.id(),
            order = javaType.order(),
            proto = javaType.proto(),
            release = javaType.release(),
            source = javaType.source(),
            sourceGroupCidrs = javaType.sourceGroupCidrs().map({ args0 -> args0 }),
            sourceGroupType = javaType.sourceGroupType(),
            sourceType = javaType.sourceType(),
        )
    }
}
