@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getControlPolicies.
 * @property aclAction The action that Cloud Firewall performs on the traffic.
 * @property aclUuid The unique ID of the access control policy.
 * @property description The description of the access control policy.
 * @property destination The destination address in the access control policy.
 * @property direction The direction of the traffic to which the access control policy applies.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Control Policy IDs.
 * @property ipVersion
 * @property lang
 * @property outputFile
 * @property policies A list of Cloud Firewall Control Policies. Each element contains the following attributes:
 * @property proto The type of the protocol in the access control policy.
 * @property source The source address in the access control policy.
 */
public data class GetControlPoliciesResult(
    public val aclAction: String? = null,
    public val aclUuid: String? = null,
    public val description: String? = null,
    public val destination: String? = null,
    public val direction: String,
    public val id: String,
    public val ids: List<String>,
    public val ipVersion: String? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val policies: List<GetControlPoliciesPolicy>,
    public val proto: String? = null,
    public val source: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetControlPoliciesResult): GetControlPoliciesResult = GetControlPoliciesResult(
            aclAction = javaType.aclAction().map({ args0 -> args0 }).orElse(null),
            aclUuid = javaType.aclUuid().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            direction = javaType.direction(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipVersion = javaType.ipVersion().map({ args0 -> args0 }).orElse(null),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetControlPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            proto = javaType.proto().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
        )
    }
}
