@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime When the cloud firewall member account was added.> use second-level timestamp format.
 * @property id
 * @property memberDesc Remarks of cloud firewall member accounts.
 * @property memberDisplayName The name of the cloud firewall member account.
 * @property memberUid The UID of the cloud firewall member account.
 * @property modifyTime The last modification time of the cloud firewall member account.> use second-level timestamp format.
 * @property status The resource attribute field that represents the resource status.
 */
public data class GetInstanceMembersMember(
    public val createTime: Int,
    public val id: String,
    public val memberDesc: String,
    public val memberDisplayName: String,
    public val memberUid: String,
    public val modifyTime: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetInstanceMembersMember): GetInstanceMembersMember = GetInstanceMembersMember(
            createTime = javaType.createTime(),
            id = javaType.id(),
            memberDesc = javaType.memberDesc(),
            memberDisplayName = javaType.memberDisplayName(),
            memberUid = javaType.memberUid(),
            modifyTime = javaType.modifyTime(),
            status = javaType.status(),
        )
    }
}
