@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceMembers.
 * @property currentPage
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Instance Member IDs.
 * @property members A list of Instance Member Entries. Each element contains the following attributes:
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetInstanceMembersResult(
    public val currentPage: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val members: List<GetInstanceMembersMember>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetInstanceMembersResult): GetInstanceMembersResult = GetInstanceMembersResult(
            currentPage = javaType.currentPage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetInstanceMembersMember.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
