@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The Creation time of the resource.
 * @property endTime The end time of the resource..
 * @property id The ID of the Instance.
 * @property instanceId The first ID of the resource.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`.
 * @property renewalDurationUnit Automatic renewal period unit. Valid values: `Month`,`Year`.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
 * @property status The Status of Instance.
 */
public data class GetInstancesInstance(
    public val createTime: String,
    public val endTime: String,
    public val id: String,
    public val instanceId: String,
    public val paymentType: String,
    public val renewalDurationUnit: String,
    public val renewalStatus: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            createTime = javaType.createTime(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            paymentType = javaType.paymentType(),
            renewalDurationUnit = javaType.renewalDurationUnit(),
            renewalStatus = javaType.renewalStatus(),
            status = javaType.status(),
        )
    }
}
