@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cenId The ID of the CEN instance.
 * @property connectType Intercommunication type, value: `expressconnect`: Express Channel `cen`: Cloud Enterprise Network
 * @property id The ID of the CEN instance.
 * @property localVpcs The details of the VPC.
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property status Firewall switch status
 * @property vpcFirewallId VPC firewall ID
 * @property vpcFirewallName The name of the VPC firewall instance.
 */
public data class GetVpcFirewallCensCen(
    public val cenId: String,
    public val connectType: String,
    public val id: String,
    public val localVpcs: List<GetVpcFirewallCensCenLocalVpc>,
    public val networkInstanceId: String,
    public val status: String,
    public val vpcFirewallId: String,
    public val vpcFirewallName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallCensCen): GetVpcFirewallCensCen = GetVpcFirewallCensCen(
            cenId = javaType.cenId(),
            connectType = javaType.connectType(),
            id = javaType.id(),
            localVpcs = javaType.localVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensCenLocalVpc.Companion.toKotlin(args0)
                })
            }),
            networkInstanceId = javaType.networkInstanceId(),
            status = javaType.status(),
            vpcFirewallId = javaType.vpcFirewallId(),
            vpcFirewallName = javaType.vpcFirewallName(),
        )
    }
}
