@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachmentId
 * @property attachmentName
 * @property defendCidrLists The list of network segments protected by the VPC firewall.
 * @property eniLists
 * @property manualVswitchId
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property networkInstanceName The name of the network instance.
 * @property networkInstanceType The type of the network instance. Value: **VPC * *.
 * @property ownerId The UID of the Alibaba Cloud account to which the VPC belongs.
 * @property regionNo The region ID of the VPC.
 * @property routeMode Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
 * @property supportManualMode Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
 * @property transitRouterId
 * @property transitRouterType The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
 * @property vpcCidrTableLists The VPC network segment list.
 * @property vpcId The ID of the VPC instance.
 * @property vpcName The instance name of the VPC.
 */
public data class GetVpcFirewallCensCenLocalVpc(
    public val attachmentId: String,
    public val attachmentName: String,
    public val defendCidrLists: List<String>,
    public val eniLists: List<GetVpcFirewallCensCenLocalVpcEniList>,
    public val manualVswitchId: String,
    public val networkInstanceId: String,
    public val networkInstanceName: String,
    public val networkInstanceType: String,
    public val ownerId: String,
    public val regionNo: String,
    public val routeMode: String,
    public val supportManualMode: String,
    public val transitRouterId: String,
    public val transitRouterType: String,
    public val vpcCidrTableLists: List<GetVpcFirewallCensCenLocalVpcVpcCidrTableList>,
    public val vpcId: String,
    public val vpcName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallCensCenLocalVpc): GetVpcFirewallCensCenLocalVpc = GetVpcFirewallCensCenLocalVpc(
            attachmentId = javaType.attachmentId(),
            attachmentName = javaType.attachmentName(),
            defendCidrLists = javaType.defendCidrLists().map({ args0 -> args0 }),
            eniLists = javaType.eniLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensCenLocalVpcEniList.Companion.toKotlin(args0)
                })
            }),
            manualVswitchId = javaType.manualVswitchId(),
            networkInstanceId = javaType.networkInstanceId(),
            networkInstanceName = javaType.networkInstanceName(),
            networkInstanceType = javaType.networkInstanceType(),
            ownerId = javaType.ownerId(),
            regionNo = javaType.regionNo(),
            routeMode = javaType.routeMode(),
            supportManualMode = javaType.supportManualMode(),
            transitRouterId = javaType.transitRouterId(),
            transitRouterType = javaType.transitRouterType(),
            vpcCidrTableLists = javaType.vpcCidrTableLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensCenLocalVpcVpcCidrTableList.Companion.toKotlin(args0)
                })
            }),
            vpcId = javaType.vpcId(),
            vpcName = javaType.vpcName(),
        )
    }
}
