@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcFirewallCens.
 * @property cenId The ID of the CEN instance.
 * @property cens A list of Vpc Firewall Cen Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Vpc Firewall Cen IDs.
 * @property lang
 * @property memberUid The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
 * @property networkInstanceId The ID of the VPC instance that created the VPC firewall.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status Firewall switch status
 * @property vpcFirewallId VPC firewall ID
 * @property vpcFirewallName The name of the VPC firewall instance.
 */
public data class GetVpcFirewallCensResult(
    public val cenId: String? = null,
    public val cens: List<GetVpcFirewallCensCen>,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val networkInstanceId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val vpcFirewallId: String? = null,
    public val vpcFirewallName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallCensResult): GetVpcFirewallCensResult = GetVpcFirewallCensResult(
            cenId = javaType.cenId().map({ args0 -> args0 }).orElse(null),
            cens = javaType.cens().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallCensCen.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            memberUid = javaType.memberUid().map({ args0 -> args0 }).orElse(null),
            networkInstanceId = javaType.networkInstanceId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcFirewallId = javaType.vpcFirewallId().map({ args0 -> args0 }).orElse(null),
            vpcFirewallName = javaType.vpcFirewallName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
