@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclAction Access control over VPC firewalls are set in the access traffic via Alibaba cloud firewall way (ACT).
 * @property aclUuid Access control over VPC firewalls strategy unique identifier.
 * @property applicationId Policy specifies the application ID.
 * @property applicationName Access control over VPC firewalls policies support the application types.
 * @property description Access control over VPC firewalls description of the strategy information.
 * @property destPort Access control over VPC firewalls strategy access traffic of the destination port.
 * @property destPortGroup Access control policy in the access traffic of the destination port address book name.
 * @property destPortGroupPorts Port Address Book port list.
 * @property destPortType Access control over VPC firewalls strategy access traffic of the destination port type.
 * @property destination Access control over VPC firewalls strategy the destination address in.
 * @property destinationGroupCidrs Destination address book defined in the address list.
 * @property destinationGroupType The destination address book type in the access control policy. Value: `ip`, `domain`.
 * @property destinationType Access control over VPC firewalls strategy in the destination address of the type.
 * @property hitTimes Control strategy of hits per second.
 * @property id The ID of the Cloud Firewall Vpc Firewall Control Policy.
 * @property memberUid The UID of the member account of the current Alibaba cloud account.
 * @property order Access control over VPC firewalls policies will go into effect of priority. The priority value starts from 1, the smaller the priority number, the higher the priority. -1 represents the lowest priority.
 * @property proto Access control over VPC firewalls strategy access traffic of the protocol type.
 * @property release The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
 * @property source Access control over VPC firewalls strategy in the source address.
 * @property sourceGroupCidrs SOURCE address of the address list.
 * @property sourceGroupType The source address type in the access control policy. Unique value: **ip**. The IP address book contains one or more IP address segments.
 * @property sourceType Access control over VPC firewalls policy source address type.
 * @property vpcFirewallId The ID of the VPC firewall instance.
 */
public data class GetVpcFirewallControlPoliciesPolicy(
    public val aclAction: String,
    public val aclUuid: String,
    public val applicationId: String,
    public val applicationName: String,
    public val description: String,
    public val destPort: String,
    public val destPortGroup: String,
    public val destPortGroupPorts: List<String>,
    public val destPortType: String,
    public val destination: String,
    public val destinationGroupCidrs: List<String>,
    public val destinationGroupType: String,
    public val destinationType: String,
    public val hitTimes: Int,
    public val id: String,
    public val memberUid: String,
    public val order: Int,
    public val proto: String,
    public val release: Boolean,
    public val source: String,
    public val sourceGroupCidrs: List<String>,
    public val sourceGroupType: String,
    public val sourceType: String,
    public val vpcFirewallId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallControlPoliciesPolicy): GetVpcFirewallControlPoliciesPolicy = GetVpcFirewallControlPoliciesPolicy(
            aclAction = javaType.aclAction(),
            aclUuid = javaType.aclUuid(),
            applicationId = javaType.applicationId(),
            applicationName = javaType.applicationName(),
            description = javaType.description(),
            destPort = javaType.destPort(),
            destPortGroup = javaType.destPortGroup(),
            destPortGroupPorts = javaType.destPortGroupPorts().map({ args0 -> args0 }),
            destPortType = javaType.destPortType(),
            destination = javaType.destination(),
            destinationGroupCidrs = javaType.destinationGroupCidrs().map({ args0 -> args0 }),
            destinationGroupType = javaType.destinationGroupType(),
            destinationType = javaType.destinationType(),
            hitTimes = javaType.hitTimes(),
            id = javaType.id(),
            memberUid = javaType.memberUid(),
            order = javaType.order(),
            proto = javaType.proto(),
            release = javaType.release(),
            source = javaType.source(),
            sourceGroupCidrs = javaType.sourceGroupCidrs().map({ args0 -> args0 }),
            sourceGroupType = javaType.sourceGroupType(),
            sourceType = javaType.sourceType(),
            vpcFirewallId = javaType.vpcFirewallId(),
        )
    }
}
