@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcFirewallControlPolicies.
 * @property aclAction
 * @property aclUuid
 * @property description
 * @property destination
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property lang
 * @property memberUid
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property policies
 * @property proto
 * @property release
 * @property source
 * @property vpcFirewallId
 */
public data class GetVpcFirewallControlPoliciesResult(
    public val aclAction: String? = null,
    public val aclUuid: String? = null,
    public val description: String? = null,
    public val destination: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val policies: List<GetVpcFirewallControlPoliciesPolicy>,
    public val proto: String? = null,
    public val release: Boolean? = null,
    public val source: String? = null,
    public val vpcFirewallId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallControlPoliciesResult): GetVpcFirewallControlPoliciesResult = GetVpcFirewallControlPoliciesResult(
            aclAction = javaType.aclAction().map({ args0 -> args0 }).orElse(null),
            aclUuid = javaType.aclUuid().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            memberUid = javaType.memberUid().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallControlPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            proto = javaType.proto().map({ args0 -> args0 }).orElse(null),
            release = javaType.release().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            vpcFirewallId = javaType.vpcFirewallId(),
        )
    }
}
