@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth Bandwidth specifications for high-speed channels. Unit: Mbps.
 * @property connectType The communication type of the VPC firewall. Valid value: **expressconnect**, which indicates Express Connect.
 * @property id The name of the VPC firewall instance and the value same as `vpc_firewall_id`.
 * @property localVpcs The details of the local VPC.
 * @property peerVpcs The details of the peer VPC.
 * @property regionStatus The region is open. Value:-**enable**: is enabled, indicating that VPC firewall can be configured in this region.-**disable**: indicates that VPC firewall cannot be configured in this region.
 * @property status The status of the resource
 * @property vpcFirewallId The ID of the VPC firewall instance.
 * @property vpcFirewallName The name of the VPC firewall instance.
 */
public data class GetVpcFirewallsFirewall(
    public val bandwidth: Int,
    public val connectType: String,
    public val id: String,
    public val localVpcs: List<GetVpcFirewallsFirewallLocalVpc>,
    public val peerVpcs: List<GetVpcFirewallsFirewallPeerVpc>,
    public val regionStatus: String,
    public val status: String,
    public val vpcFirewallId: String,
    public val vpcFirewallName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallsFirewall): GetVpcFirewallsFirewall = GetVpcFirewallsFirewall(
            bandwidth = javaType.bandwidth(),
            connectType = javaType.connectType(),
            id = javaType.id(),
            localVpcs = javaType.localVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsFirewallLocalVpc.Companion.toKotlin(args0)
                })
            }),
            peerVpcs = javaType.peerVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsFirewallPeerVpc.Companion.toKotlin(args0)
                })
            }),
            regionStatus = javaType.regionStatus(),
            status = javaType.status(),
            vpcFirewallId = javaType.vpcFirewallId(),
            vpcFirewallName = javaType.vpcFirewallName(),
        )
    }
}
