@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eniId
 * @property eniPrivateIpAddress
 * @property peerVpcCidrTableLists The network segment list of the peer VPC.
 * @property regionNo The region ID of the peer VPC.
 * @property routerInterfaceId
 * @property vpcId The ID of the peer VPC instance.
 * @property vpcName The instance name of the peer VPC.
 */
public data class GetVpcFirewallsFirewallPeerVpc(
    public val eniId: String,
    public val eniPrivateIpAddress: String,
    public val peerVpcCidrTableLists: List<GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableList>,
    public val regionNo: String,
    public val routerInterfaceId: String,
    public val vpcId: String,
    public val vpcName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallsFirewallPeerVpc): GetVpcFirewallsFirewallPeerVpc = GetVpcFirewallsFirewallPeerVpc(
            eniId = javaType.eniId(),
            eniPrivateIpAddress = javaType.eniPrivateIpAddress(),
            peerVpcCidrTableLists = javaType.peerVpcCidrTableLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableList.Companion.toKotlin(args0)
                })
            }),
            regionNo = javaType.regionNo(),
            routerInterfaceId = javaType.routerInterfaceId(),
            vpcId = javaType.vpcId(),
            vpcName = javaType.vpcName(),
        )
    }
}
