@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcFirewalls.
 * @property firewalls A list of Vpc Firewall Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Vpc Firewall IDs.
 * @property lang
 * @property memberUid The UID of the Alibaba Cloud member account.
 * @property nameRegex
 * @property names A list of name of Vpc Firewalls.
 * @property outputFile
 * @property regionNo The region ID of the peer VPC.
 * @property status The status of the resource
 * @property vpcFirewallId The ID of the VPC firewall instance.
 * @property vpcFirewallName The name of the VPC firewall instance.
 * @property vpcId The ID of the peer VPC instance.
 */
public data class GetVpcFirewallsResult(
    public val firewalls: List<GetVpcFirewallsFirewall>,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val memberUid: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val regionNo: String? = null,
    public val status: String? = null,
    public val vpcFirewallId: String? = null,
    public val vpcFirewallName: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.GetVpcFirewallsResult): GetVpcFirewallsResult = GetVpcFirewallsResult(
            firewalls = javaType.firewalls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudfirewall.kotlin.outputs.GetVpcFirewallsFirewall.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            memberUid = javaType.memberUid().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regionNo = javaType.regionNo().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcFirewallId = javaType.vpcFirewallId().map({ args0 -> args0 }).orElse(null),
            vpcFirewallName = javaType.vpcFirewallName().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
