@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationCidr The destination network segment of the default route.
 * @property nexthopId The next hop address of the original NAT gateway.
 * @property nexthopType The network type of the next hop. Value: NatGateway : NAT Gateway.
 * @property routeTableId The route table where the default route of the NAT gateway is located.
 */
public data class NatFirewallNatRouteEntryList(
    public val destinationCidr: String,
    public val nexthopId: String,
    public val nexthopType: String,
    public val routeTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudfirewall.outputs.NatFirewallNatRouteEntryList): NatFirewallNatRouteEntryList = NatFirewallNatRouteEntryList(
            destinationCidr = javaType.destinationCidr(),
            nexthopId = javaType.nexthopId(),
            nexthopType = javaType.nexthopType(),
            routeTableId = javaType.routeTableId(),
        )
    }
}
