@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.alicloud.cloudmonitor.CloudmonitorFunctions.getServiceHybridDoubleWritesPlain
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.GetServiceHybridDoubleWritesPlainArgs
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.GetServiceHybridDoubleWritesPlainArgsBuilder
import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.GetServiceHybridDoubleWritesResult
import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.GetServiceHybridDoubleWritesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object CloudmonitorFunctions {
    /**
     * This data source provides the Cloud Monitor Service Hybrid Double Writes of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.220.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.getAccount({});
     * const source = new alicloud.cms.Namespace("source", {namespace: "your-source-namespace"});
     * const defaultNamespace = new alicloud.cms.Namespace("default", {namespace: "your-namespace"});
     * const defaultServiceHybridDoubleWrite = new alicloud.cloudmonitor.ServiceHybridDoubleWrite("default", {
     *     sourceNamespace: source.id,
     *     sourceUserId: _default.then(_default => _default.id),
     *     namespace: defaultNamespace.id,
     *     userId: _default.then(_default => _default.id),
     * });
     * const ids = alicloud.cloudmonitor.getServiceHybridDoubleWritesOutput({
     *     ids: [defaultServiceHybridDoubleWrite&#46;id],
     * });
     * export const cloudMonitorServiceHybridDoubleWritesId1 = ids.apply(ids => ids.hybridDoubleWrites?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.get_account()
     * source = alicloud.cms.Namespace("source", namespace="your-source-namespace")
     * default_namespace = alicloud.cms.Namespace("default", namespace="your-namespace")
     * default_service_hybrid_double_write = alicloud.cloudmonitor.ServiceHybridDoubleWrite("default",
     *     source_namespace=source.id,
     *     source_user_id=default.id,
     *     namespace=default_namespace.id,
     *     user_id=default.id)
     * ids = alicloud.cloudmonitor.get_service_hybrid_double_writes_output(ids=[default_service_hybrid_double_write&#46;id])
     * pulumi.export("cloudMonitorServiceHybridDoubleWritesId1", ids.hybrid_double_writes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.GetAccount.Invoke();
     *     var source = new AliCloud.Cms.Namespace("source", new()
     *     {
     *         NamespaceName = "your-source-namespace",
     *     });
     *     var defaultNamespace = new AliCloud.Cms.Namespace("default", new()
     *     {
     *         NamespaceName = "your-namespace",
     *     });
     *     var defaultServiceHybridDoubleWrite = new AliCloud.CloudMonitor.ServiceHybridDoubleWrite("default", new()
     *     {
     *         SourceNamespace = source.Id,
     *         SourceUserId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
     *         Namespace = defaultNamespace.Id,
     *         UserId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
     *     });
     *     var ids = AliCloud.CloudMonitor.GetServiceHybridDoubleWrites.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultServiceHybridDoubleWrite.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudMonitorServiceHybridDoubleWritesId1"] = ids&#46;Apply(getServiceHybridDoubleWritesResult => getServiceHybridDoubleWritesResult&#46;HybridDoubleWrites[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		source, err := cms.NewNamespace(ctx, "source", &cms.NamespaceArgs{
     * 			Namespace: pulumi.String("your-source-namespace"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNamespace, err := cms.NewNamespace(ctx, "default", &cms.NamespaceArgs{
     * 			Namespace: pulumi.String("your-namespace"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultServiceHybridDoubleWrite, err := cloudmonitor.NewServiceHybridDoubleWrite(ctx, "default", &cloudmonitor.ServiceHybridDoubleWriteArgs{
     * 			SourceNamespace: source.ID(),
     * 			SourceUserId:    pulumi.String(_default.Id),
     * 			Namespace:       defaultNamespace.ID(),
     * 			UserId:          pulumi.String(_default.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := cloudmonitor.GetServiceHybridDoubleWritesOutput(ctx, cloudmonitor.GetServiceHybridDoubleWritesOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultServiceHybridDoubleWrite.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("cloudMonitorServiceHybridDoubleWritesId1", ids.ApplyT(func(ids cloudmonitor.GetServiceHybridDoubleWritesResult) (*string, error) {
     * 			return &ids.HybridDoubleWrites[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.cms.Namespace;
     * import com.pulumi.alicloud.cms.NamespaceArgs;
     * import com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite;
     * import com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWriteArgs;
     * import com.pulumi.alicloud.cloudmonitor.CloudmonitorFunctions;
     * import com.pulumi.alicloud.cloudmonitor.inputs.GetServiceHybridDoubleWritesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AlicloudFunctions.getAccount();
     *         var source = new Namespace("source", NamespaceArgs.builder()
     *             .namespace("your-source-namespace")
     *             .build());
     *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
     *             .namespace("your-namespace")
     *             .build());
     *         var defaultServiceHybridDoubleWrite = new ServiceHybridDoubleWrite("defaultServiceHybridDoubleWrite", ServiceHybridDoubleWriteArgs.builder()
     *             .sourceNamespace(source.id())
     *             .sourceUserId(default_.id())
     *             .namespace(defaultNamespace.id())
     *             .userId(default_.id())
     *             .build());
     *         final var ids = CloudmonitorFunctions.getServiceHybridDoubleWrites(GetServiceHybridDoubleWritesArgs.builder()
     *             .ids(defaultServiceHybridDoubleWrite.id())
     *             .build());
     *         ctx.export("cloudMonitorServiceHybridDoubleWritesId1", ids.applyValue(getServiceHybridDoubleWritesResult -> getServiceHybridDoubleWritesResult).applyValue(ids -> ids.applyValue(getServiceHybridDoubleWritesResult -> getServiceHybridDoubleWritesResult.hybridDoubleWrites()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   source:
     *     type: alicloud:cms:Namespace
     *     properties:
     *       namespace: your-source-namespace
     *   defaultNamespace:
     *     type: alicloud:cms:Namespace
     *     name: default
     *     properties:
     *       namespace: your-namespace
     *   defaultServiceHybridDoubleWrite:
     *     type: alicloud:cloudmonitor:ServiceHybridDoubleWrite
     *     name: default
     *     properties:
     *       sourceNamespace: ${source.id}
     *       sourceUserId: ${default.id}
     *       namespace: ${defaultNamespace.id}
     *       userId: ${default.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getAccount
     *       Arguments: {}
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudmonitor:getServiceHybridDoubleWrites
     *       Arguments:
     *         ids:
     *           - ${defaultServiceHybridDoubleWrite.id}
     * outputs:
     *   cloudMonitorServiceHybridDoubleWritesId1: ${ids.hybridDoubleWrites[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceHybridDoubleWrites.
     * @return A collection of values returned by getServiceHybridDoubleWrites.
     */
    public suspend fun getServiceHybridDoubleWrites(argument: GetServiceHybridDoubleWritesPlainArgs): GetServiceHybridDoubleWritesResult =
        toKotlin(getServiceHybridDoubleWritesPlain(argument.toJava()).await())

    /**
     * @see [getServiceHybridDoubleWrites].
     * @param ids A list of Hybrid Double Write IDs.
     * @param namespace Target Namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param sourceNamespace Source Namespace.
     * @param sourceUserId Source UserId.
     * @param userId Target UserId.
     * @return A collection of values returned by getServiceHybridDoubleWrites.
     */
    public suspend fun getServiceHybridDoubleWrites(
        ids: List<String>? = null,
        namespace: String? = null,
        outputFile: String? = null,
        sourceNamespace: String? = null,
        sourceUserId: String? = null,
        userId: String? = null,
    ): GetServiceHybridDoubleWritesResult {
        val argument = GetServiceHybridDoubleWritesPlainArgs(
            ids = ids,
            namespace = namespace,
            outputFile = outputFile,
            sourceNamespace = sourceNamespace,
            sourceUserId = sourceUserId,
            userId = userId,
        )
        return toKotlin(getServiceHybridDoubleWritesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceHybridDoubleWrites].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudmonitor&#46;kotlin&#46;inputs&#46;GetServiceHybridDoubleWritesPlainArgs].
     * @return A collection of values returned by getServiceHybridDoubleWrites.
     */
    public suspend fun getServiceHybridDoubleWrites(argument: suspend GetServiceHybridDoubleWritesPlainArgsBuilder.() -> Unit): GetServiceHybridDoubleWritesResult {
        val builder = GetServiceHybridDoubleWritesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getServiceHybridDoubleWritesPlain(builtArgument.toJava()).await())
    }
}
