@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceBasicPublic].
 */
@PulumiTagMarker
public class ServiceBasicPublicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceBasicPublicArgs = ServiceBasicPublicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceBasicPublicArgsBuilder.() -> Unit) {
        val builder = ServiceBasicPublicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceBasicPublic {
        val builtJavaResource =
            com.pulumi.alicloud.cloudmonitor.ServiceBasicPublic(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceBasicPublic(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Basic Public resource.
 * For information about Cloud Monitor Service Basic Public and how to use it, see [What is Basic Public](https://www.alibabacloud.com/help/en/cms/product-overview/what-is-cloudmonitor).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cloudmonitor.ServiceBasicPublic("default", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cloudmonitor.ServiceBasicPublic("default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.CloudMonitor.ServiceBasicPublic("default");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cloudmonitor.NewServiceBasicPublic(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudmonitor.ServiceBasicPublic;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ServiceBasicPublic("default");
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cloudmonitor:ServiceBasicPublic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Basic Public can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudmonitor/serviceBasicPublic:ServiceBasicPublic example <id>
 * ```
 */
public class ServiceBasicPublic internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudmonitor.ServiceBasicPublic,
) : KotlinCustomResource(javaResource, ServiceBasicPublicMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })
}

public object ServiceBasicPublicMapper : ResourceMapper<ServiceBasicPublic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudmonitor.ServiceBasicPublic::class == javaResource::class

    override fun map(javaResource: Resource): ServiceBasicPublic = ServiceBasicPublic(
        javaResource as
            com.pulumi.alicloud.cloudmonitor.ServiceBasicPublic,
    )
}

/**
 * @see [ServiceBasicPublic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceBasicPublic].
 */
public suspend fun serviceBasicPublic(
    name: String,
    block: suspend ServiceBasicPublicResourceBuilder.() -> Unit,
): ServiceBasicPublic {
    val builder = ServiceBasicPublicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceBasicPublic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceBasicPublic(name: String): ServiceBasicPublic {
    val builder = ServiceBasicPublicResourceBuilder()
    builder.name(name)
    return builder.build()
}
