@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceEnterprisePublic].
 */
@PulumiTagMarker
public class ServiceEnterprisePublicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceEnterprisePublicArgs = ServiceEnterprisePublicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceEnterprisePublicArgsBuilder.() -> Unit) {
        val builder = ServiceEnterprisePublicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceEnterprisePublic {
        val builtJavaResource =
            com.pulumi.alicloud.cloudmonitor.ServiceEnterprisePublic(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceEnterprisePublic(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Enterprise Public resource. Hybrid Cloud Monitoring.
 * For information about Cloud Monitor Service Enterprise Public and how to use it, see [What is Enterprise Public](https://www.alibabacloud.com/help/en/cms/user-guide/overview-3).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cloudmonitor.ServiceEnterprisePublic("default", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cloudmonitor.ServiceEnterprisePublic("default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.CloudMonitor.ServiceEnterprisePublic("default");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cloudmonitor.NewServiceEnterprisePublic(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudmonitor.ServiceEnterprisePublic;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ServiceEnterprisePublic("default");
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cloudmonitor:ServiceEnterprisePublic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Enterprise Public can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudmonitor/serviceEnterprisePublic:ServiceEnterprisePublic example <id>
 * ```
 */
public class ServiceEnterprisePublic internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudmonitor.ServiceEnterprisePublic,
) : KotlinCustomResource(javaResource, ServiceEnterprisePublicMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })
}

public object ServiceEnterprisePublicMapper : ResourceMapper<ServiceEnterprisePublic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudmonitor.ServiceEnterprisePublic::class == javaResource::class

    override fun map(javaResource: Resource): ServiceEnterprisePublic =
        ServiceEnterprisePublic(
            javaResource as
                com.pulumi.alicloud.cloudmonitor.ServiceEnterprisePublic,
        )
}

/**
 * @see [ServiceEnterprisePublic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceEnterprisePublic].
 */
public suspend fun serviceEnterprisePublic(
    name: String,
    block: suspend ServiceEnterprisePublicResourceBuilder.() -> Unit,
): ServiceEnterprisePublic {
    val builder = ServiceEnterprisePublicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceEnterprisePublic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceEnterprisePublic(name: String): ServiceEnterprisePublic {
    val builder = ServiceEnterprisePublicResourceBuilder()
    builder.name(name)
    return builder.build()
}
