@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.ServiceGroupMonitoringAgentProcessAlertConfig
import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.ServiceGroupMonitoringAgentProcessMatchExpress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.ServiceGroupMonitoringAgentProcessAlertConfig.Companion.toKotlin as serviceGroupMonitoringAgentProcessAlertConfigToKotlin
import com.pulumi.alicloud.cloudmonitor.kotlin.outputs.ServiceGroupMonitoringAgentProcessMatchExpress.Companion.toKotlin as serviceGroupMonitoringAgentProcessMatchExpressToKotlin

/**
 * Builder for [ServiceGroupMonitoringAgentProcess].
 */
@PulumiTagMarker
public class ServiceGroupMonitoringAgentProcessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceGroupMonitoringAgentProcessArgs = ServiceGroupMonitoringAgentProcessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceGroupMonitoringAgentProcessArgsBuilder.() -> Unit) {
        val builder = ServiceGroupMonitoringAgentProcessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceGroupMonitoringAgentProcess {
        val builtJavaResource =
            com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceGroupMonitoringAgentProcess(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Group Monitoring Agent Process resource.
 * For information about Cloud Monitor Service Group Monitoring Agent Process and how to use it, see [What is Group Monitoring Agent Process](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-creategroupmonitoringagentprocess).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {
 *     alarmContactGroupName: name,
 *     contacts: [
 *         "user",
 *         "user1",
 *         "user2",
 *     ],
 * });
 * const defaultMonitorGroup = new alicloud.cms.MonitorGroup("default", {
 *     monitorGroupName: name,
 *     contactGroups: [_default&#46;id],
 * });
 * const defaultServiceGroupMonitoringAgentProcess = new alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess("default", {
 *     groupId: defaultMonitorGroup.id,
 *     processName: name,
 *     matchExpressFilterRelation: "or",
 *     matchExpresses: [{
 *         name: name,
 *         value: "*",
 *         "function": "all",
 *     }],
 *     alertConfigs: [{
 *         escalationsLevel: "critical",
 *         comparisonOperator: "GreaterThanOrEqualToThreshold",
 *         statistics: "Average",
 *         threshold: "20",
 *         times: "100",
 *         effectiveInterval: "00:00-22:59",
 *         silenceTime: 85800,
 *         webhook: "https://www.aliyun.com",
 *         targetLists: [{
 *             targetListId: "1",
 *             jsonParams: "{}",
 *             level: "WARN",
 *             arn: "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cms.AlarmContactGroup("default",
 *     alarm_contact_group_name=name,
 *     contacts=[
 *         "user",
 *         "user1",
 *         "user2",
 *     ])
 * default_monitor_group = alicloud.cms.MonitorGroup("default",
 *     monitor_group_name=name,
 *     contact_groups=[default&#46;id])
 * default_service_group_monitoring_agent_process = alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess("default",
 *     group_id=default_monitor_group.id,
 *     process_name=name,
 *     match_express_filter_relation="or",
 *     match_expresses=[{
 *         "name": name,
 *         "value": "*",
 *         "function": "all",
 *     }],
 *     alert_configs=[{
 *         "escalations_level": "critical",
 *         "comparison_operator": "GreaterThanOrEqualToThreshold",
 *         "statistics": "Average",
 *         "threshold": "20",
 *         "times": "100",
 *         "effective_interval": "00:00-22:59",
 *         "silence_time": 85800,
 *         "webhook": "https://www.aliyun.com",
 *         "target_lists": [{
 *             "target_list_id": "1",
 *             "json_params": "{}",
 *             "level": "WARN",
 *             "arn": "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *         Contacts = new[]
 *         {
 *             "user",
 *             "user1",
 *             "user2",
 *         },
 *     });
 *     var defaultMonitorGroup = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *         ContactGroups = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var defaultServiceGroupMonitoringAgentProcess = new AliCloud.CloudMonitor.ServiceGroupMonitoringAgentProcess("default", new()
 *     {
 *         GroupId = defaultMonitorGroup.Id,
 *         ProcessName = name,
 *         MatchExpressFilterRelation = "or",
 *         MatchExpresses = new[]
 *         {
 *             new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs
 *             {
 *                 Name = name,
 *                 Value = "*",
 *                 Function = "all",
 *             },
 *         },
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs
 *             {
 *                 EscalationsLevel = "critical",
 *                 ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *                 Statistics = "Average",
 *                 Threshold = "20",
 *                 Times = "100",
 *                 EffectiveInterval = "00:00-22:59",
 *                 SilenceTime = 85800,
 *                 Webhook = "https://www.aliyun.com",
 *                 TargetLists = new[]
 *                 {
 *                     new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs
 *                     {
 *                         TargetListId = "1",
 *                         JsonParams = "{}",
 *                         Level = "WARN",
 *                         Arn = "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 			Contacts: pulumi.StringArray{
 * 				pulumi.String("user"),
 * 				pulumi.String("user1"),
 * 				pulumi.String("user2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMonitorGroup, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 			ContactGroups: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudmonitor.NewServiceGroupMonitoringAgentProcess(ctx, "default", &cloudmonitor.ServiceGroupMonitoringAgentProcessArgs{
 * 			GroupId:                    defaultMonitorGroup.ID(),
 * 			ProcessName:                pulumi.String(name),
 * 			MatchExpressFilterRelation: pulumi.String("or"),
 * 			MatchExpresses: cloudmonitor.ServiceGroupMonitoringAgentProcessMatchExpressArray{
 * 				&cloudmonitor.ServiceGroupMonitoringAgentProcessMatchExpressArgs{
 * 					Name:     pulumi.String(name),
 * 					Value:    pulumi.String("*"),
 * 					Function: pulumi.String("all"),
 * 				},
 * 			},
 * 			AlertConfigs: cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigArray{
 * 				&cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigArgs{
 * 					EscalationsLevel:   pulumi.String("critical"),
 * 					ComparisonOperator: pulumi.String("GreaterThanOrEqualToThreshold"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("20"),
 * 					Times:              pulumi.String("100"),
 * 					EffectiveInterval:  pulumi.String("00:00-22:59"),
 * 					SilenceTime:        pulumi.Int(85800),
 * 					Webhook:            pulumi.String("https://www.aliyun.com"),
 * 					TargetLists: cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArray{
 * 						&cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs{
 * 							TargetListId: pulumi.String("1"),
 * 							JsonParams:   pulumi.String("{}"),
 * 							Level:        pulumi.String("WARN"),
 * 							Arn:          pulumi.String("acs:mns:cn-hangzhou:120886317861****:/queues/test123/message"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess;
 * import com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs;
 * import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs;
 * import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .contacts(
 *                 "user",
 *                 "user1",
 *                 "user2")
 *             .build());
 *         var defaultMonitorGroup = new MonitorGroup("defaultMonitorGroup", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .contactGroups(default_.id())
 *             .build());
 *         var defaultServiceGroupMonitoringAgentProcess = new ServiceGroupMonitoringAgentProcess("defaultServiceGroupMonitoringAgentProcess", ServiceGroupMonitoringAgentProcessArgs.builder()
 *             .groupId(defaultMonitorGroup.id())
 *             .processName(name)
 *             .matchExpressFilterRelation("or")
 *             .matchExpresses(ServiceGroupMonitoringAgentProcessMatchExpressArgs.builder()
 *                 .name(name)
 *                 .value("*")
 *                 .function("all")
 *                 .build())
 *             .alertConfigs(ServiceGroupMonitoringAgentProcessAlertConfigArgs.builder()
 *                 .escalationsLevel("critical")
 *                 .comparisonOperator("GreaterThanOrEqualToThreshold")
 *                 .statistics("Average")
 *                 .threshold("20")
 *                 .times("100")
 *                 .effectiveInterval("00:00-22:59")
 *                 .silenceTime("85800")
 *                 .webhook("https://www.aliyun.com")
 *                 .targetLists(ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs.builder()
 *                     .targetListId("1")
 *                     .jsonParams("{}")
 *                     .level("WARN")
 *                     .arn("acs:mns:cn-hangzhou:120886317861****:/queues/test123/message")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *       contacts:
 *         - user
 *         - user1
 *         - user2
 *   defaultMonitorGroup:
 *     type: alicloud:cms:MonitorGroup
 *     name: default
 *     properties:
 *       monitorGroupName: ${name}
 *       contactGroups:
 *         - ${default.id}
 *   defaultServiceGroupMonitoringAgentProcess:
 *     type: alicloud:cloudmonitor:ServiceGroupMonitoringAgentProcess
 *     name: default
 *     properties:
 *       groupId: ${defaultMonitorGroup.id}
 *       processName: ${name}
 *       matchExpressFilterRelation: or
 *       matchExpresses:
 *         - name: ${name}
 *           value: '*'
 *           function: all
 *       alertConfigs:
 *         - escalationsLevel: critical
 *           comparisonOperator: GreaterThanOrEqualToThreshold
 *           statistics: Average
 *           threshold: '20'
 *           times: '100'
 *           effectiveInterval: 00:00-22:59
 *           silenceTime: '85800'
 *           webhook: https://www.aliyun.com
 *           targetLists:
 *             - targetListId: '1'
 *               jsonParams: '{}'
 *               level: WARN
 *               arn: acs:mns:cn-hangzhou:120886317861****:/queues/test123/message
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Group Monitoring Agent Process can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudmonitor/serviceGroupMonitoringAgentProcess:ServiceGroupMonitoringAgentProcess example <group_id>:<group_monitoring_agent_process_id>
 * ```
 */
public class ServiceGroupMonitoringAgentProcess internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess,
) : KotlinCustomResource(javaResource, ServiceGroupMonitoringAgentProcessMapper) {
    /**
     * The alert rule configurations. See `alert_config` below.
     */
    public val alertConfigs: Output<List<ServiceGroupMonitoringAgentProcessAlertConfig>>
        get() = javaResource.alertConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceGroupMonitoringAgentProcessAlertConfigToKotlin(args0)
                })
            })
        })

    /**
     * The ID of the application group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Group Monitoring Agent Process.
     */
    public val groupMonitoringAgentProcessId: Output<String>
        get() = javaResource.groupMonitoringAgentProcessId().applyValue({ args0 -> args0 })

    /**
     * The logical operator used between conditional expressions that are used to match instances. Valid values: `all`, `and`, `or`.
     */
    public val matchExpressFilterRelation: Output<String>
        get() = javaResource.matchExpressFilterRelation().applyValue({ args0 -> args0 })

    /**
     * The expressions used to match instances. See `match_express` below.
     */
    public val matchExpresses: Output<List<ServiceGroupMonitoringAgentProcessMatchExpress>>
        get() = javaResource.matchExpresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceGroupMonitoringAgentProcessMatchExpressToKotlin(args0) })
            })
        })

    /**
     * The name of the process.
     */
    public val processName: Output<String>
        get() = javaResource.processName().applyValue({ args0 -> args0 })
}

public object ServiceGroupMonitoringAgentProcessMapper :
    ResourceMapper<ServiceGroupMonitoringAgentProcess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess::class == javaResource::class

    override fun map(javaResource: Resource): ServiceGroupMonitoringAgentProcess =
        ServiceGroupMonitoringAgentProcess(
            javaResource as
                com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess,
        )
}

/**
 * @see [ServiceGroupMonitoringAgentProcess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceGroupMonitoringAgentProcess].
 */
public suspend fun serviceGroupMonitoringAgentProcess(
    name: String,
    block: suspend ServiceGroupMonitoringAgentProcessResourceBuilder.() -> Unit,
): ServiceGroupMonitoringAgentProcess {
    val builder = ServiceGroupMonitoringAgentProcessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceGroupMonitoringAgentProcess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceGroupMonitoringAgentProcess(name: String): ServiceGroupMonitoringAgentProcess {
    val builder = ServiceGroupMonitoringAgentProcessResourceBuilder()
    builder.name(name)
    return builder.build()
}
