@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs.builder
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs
import com.pulumi.alicloud.cloudmonitor.kotlin.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Group Monitoring Agent Process resource.
 * For information about Cloud Monitor Service Group Monitoring Agent Process and how to use it, see [What is Group Monitoring Agent Process](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-creategroupmonitoringagentprocess).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {
 *     alarmContactGroupName: name,
 *     contacts: [
 *         "user",
 *         "user1",
 *         "user2",
 *     ],
 * });
 * const defaultMonitorGroup = new alicloud.cms.MonitorGroup("default", {
 *     monitorGroupName: name,
 *     contactGroups: [_default&#46;id],
 * });
 * const defaultServiceGroupMonitoringAgentProcess = new alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess("default", {
 *     groupId: defaultMonitorGroup.id,
 *     processName: name,
 *     matchExpressFilterRelation: "or",
 *     matchExpresses: [{
 *         name: name,
 *         value: "*",
 *         "function": "all",
 *     }],
 *     alertConfigs: [{
 *         escalationsLevel: "critical",
 *         comparisonOperator: "GreaterThanOrEqualToThreshold",
 *         statistics: "Average",
 *         threshold: "20",
 *         times: "100",
 *         effectiveInterval: "00:00-22:59",
 *         silenceTime: 85800,
 *         webhook: "https://www.aliyun.com",
 *         targetLists: [{
 *             targetListId: "1",
 *             jsonParams: "{}",
 *             level: "WARN",
 *             arn: "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cms.AlarmContactGroup("default",
 *     alarm_contact_group_name=name,
 *     contacts=[
 *         "user",
 *         "user1",
 *         "user2",
 *     ])
 * default_monitor_group = alicloud.cms.MonitorGroup("default",
 *     monitor_group_name=name,
 *     contact_groups=[default&#46;id])
 * default_service_group_monitoring_agent_process = alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess("default",
 *     group_id=default_monitor_group.id,
 *     process_name=name,
 *     match_express_filter_relation="or",
 *     match_expresses=[{
 *         "name": name,
 *         "value": "*",
 *         "function": "all",
 *     }],
 *     alert_configs=[{
 *         "escalations_level": "critical",
 *         "comparison_operator": "GreaterThanOrEqualToThreshold",
 *         "statistics": "Average",
 *         "threshold": "20",
 *         "times": "100",
 *         "effective_interval": "00:00-22:59",
 *         "silence_time": 85800,
 *         "webhook": "https://www.aliyun.com",
 *         "target_lists": [{
 *             "target_list_id": "1",
 *             "json_params": "{}",
 *             "level": "WARN",
 *             "arn": "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *         Contacts = new[]
 *         {
 *             "user",
 *             "user1",
 *             "user2",
 *         },
 *     });
 *     var defaultMonitorGroup = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *         ContactGroups = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var defaultServiceGroupMonitoringAgentProcess = new AliCloud.CloudMonitor.ServiceGroupMonitoringAgentProcess("default", new()
 *     {
 *         GroupId = defaultMonitorGroup.Id,
 *         ProcessName = name,
 *         MatchExpressFilterRelation = "or",
 *         MatchExpresses = new[]
 *         {
 *             new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs
 *             {
 *                 Name = name,
 *                 Value = "*",
 *                 Function = "all",
 *             },
 *         },
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs
 *             {
 *                 EscalationsLevel = "critical",
 *                 ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *                 Statistics = "Average",
 *                 Threshold = "20",
 *                 Times = "100",
 *                 EffectiveInterval = "00:00-22:59",
 *                 SilenceTime = 85800,
 *                 Webhook = "https://www.aliyun.com",
 *                 TargetLists = new[]
 *                 {
 *                     new AliCloud.CloudMonitor.Inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs
 *                     {
 *                         TargetListId = "1",
 *                         JsonParams = "{}",
 *                         Level = "WARN",
 *                         Arn = "acs:mns:cn-hangzhou:120886317861****:/queues/test123/message",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 			Contacts: pulumi.StringArray{
 * 				pulumi.String("user"),
 * 				pulumi.String("user1"),
 * 				pulumi.String("user2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMonitorGroup, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 			ContactGroups: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudmonitor.NewServiceGroupMonitoringAgentProcess(ctx, "default", &cloudmonitor.ServiceGroupMonitoringAgentProcessArgs{
 * 			GroupId:                    defaultMonitorGroup.ID(),
 * 			ProcessName:                pulumi.String(name),
 * 			MatchExpressFilterRelation: pulumi.String("or"),
 * 			MatchExpresses: cloudmonitor.ServiceGroupMonitoringAgentProcessMatchExpressArray{
 * 				&cloudmonitor.ServiceGroupMonitoringAgentProcessMatchExpressArgs{
 * 					Name:     pulumi.String(name),
 * 					Value:    pulumi.String("*"),
 * 					Function: pulumi.String("all"),
 * 				},
 * 			},
 * 			AlertConfigs: cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigArray{
 * 				&cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigArgs{
 * 					EscalationsLevel:   pulumi.String("critical"),
 * 					ComparisonOperator: pulumi.String("GreaterThanOrEqualToThreshold"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("20"),
 * 					Times:              pulumi.String("100"),
 * 					EffectiveInterval:  pulumi.String("00:00-22:59"),
 * 					SilenceTime:        pulumi.Int(85800),
 * 					Webhook:            pulumi.String("https://www.aliyun.com"),
 * 					TargetLists: cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArray{
 * 						&cloudmonitor.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs{
 * 							TargetListId: pulumi.String("1"),
 * 							JsonParams:   pulumi.String("{}"),
 * 							Level:        pulumi.String("WARN"),
 * 							Arn:          pulumi.String("acs:mns:cn-hangzhou:120886317861****:/queues/test123/message"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcess;
 * import com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs;
 * import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs;
 * import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .contacts(
 *                 "user",
 *                 "user1",
 *                 "user2")
 *             .build());
 *         var defaultMonitorGroup = new MonitorGroup("defaultMonitorGroup", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .contactGroups(default_.id())
 *             .build());
 *         var defaultServiceGroupMonitoringAgentProcess = new ServiceGroupMonitoringAgentProcess("defaultServiceGroupMonitoringAgentProcess", ServiceGroupMonitoringAgentProcessArgs.builder()
 *             .groupId(defaultMonitorGroup.id())
 *             .processName(name)
 *             .matchExpressFilterRelation("or")
 *             .matchExpresses(ServiceGroupMonitoringAgentProcessMatchExpressArgs.builder()
 *                 .name(name)
 *                 .value("*")
 *                 .function("all")
 *                 .build())
 *             .alertConfigs(ServiceGroupMonitoringAgentProcessAlertConfigArgs.builder()
 *                 .escalationsLevel("critical")
 *                 .comparisonOperator("GreaterThanOrEqualToThreshold")
 *                 .statistics("Average")
 *                 .threshold("20")
 *                 .times("100")
 *                 .effectiveInterval("00:00-22:59")
 *                 .silenceTime("85800")
 *                 .webhook("https://www.aliyun.com")
 *                 .targetLists(ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs.builder()
 *                     .targetListId("1")
 *                     .jsonParams("{}")
 *                     .level("WARN")
 *                     .arn("acs:mns:cn-hangzhou:120886317861****:/queues/test123/message")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *       contacts:
 *         - user
 *         - user1
 *         - user2
 *   defaultMonitorGroup:
 *     type: alicloud:cms:MonitorGroup
 *     name: default
 *     properties:
 *       monitorGroupName: ${name}
 *       contactGroups:
 *         - ${default.id}
 *   defaultServiceGroupMonitoringAgentProcess:
 *     type: alicloud:cloudmonitor:ServiceGroupMonitoringAgentProcess
 *     name: default
 *     properties:
 *       groupId: ${defaultMonitorGroup.id}
 *       processName: ${name}
 *       matchExpressFilterRelation: or
 *       matchExpresses:
 *         - name: ${name}
 *           value: '*'
 *           function: all
 *       alertConfigs:
 *         - escalationsLevel: critical
 *           comparisonOperator: GreaterThanOrEqualToThreshold
 *           statistics: Average
 *           threshold: '20'
 *           times: '100'
 *           effectiveInterval: 00:00-22:59
 *           silenceTime: '85800'
 *           webhook: https://www.aliyun.com
 *           targetLists:
 *             - targetListId: '1'
 *               jsonParams: '{}'
 *               level: WARN
 *               arn: acs:mns:cn-hangzhou:120886317861****:/queues/test123/message
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Group Monitoring Agent Process can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudmonitor/serviceGroupMonitoringAgentProcess:ServiceGroupMonitoringAgentProcess example <group_id>:<group_monitoring_agent_process_id>
 * ```
 * @property alertConfigs The alert rule configurations. See `alert_config` below.
 * @property groupId The ID of the application group.
 * @property matchExpressFilterRelation The logical operator used between conditional expressions that are used to match instances. Valid values: `all`, `and`, `or`.
 * @property matchExpresses The expressions used to match instances. See `match_express` below.
 * @property processName The name of the process.
 */
public data class ServiceGroupMonitoringAgentProcessArgs(
    public val alertConfigs: Output<List<ServiceGroupMonitoringAgentProcessAlertConfigArgs>>? = null,
    public val groupId: Output<String>? = null,
    public val matchExpressFilterRelation: Output<String>? = null,
    public val matchExpresses: Output<List<ServiceGroupMonitoringAgentProcessMatchExpressArgs>>? =
        null,
    public val processName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs =
        com.pulumi.alicloud.cloudmonitor.ServiceGroupMonitoringAgentProcessArgs.builder()
            .alertConfigs(
                alertConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .matchExpressFilterRelation(matchExpressFilterRelation?.applyValue({ args0 -> args0 }))
            .matchExpresses(
                matchExpresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processName(processName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceGroupMonitoringAgentProcessArgs].
 */
@PulumiTagMarker
public class ServiceGroupMonitoringAgentProcessArgsBuilder internal constructor() {
    private var alertConfigs: Output<List<ServiceGroupMonitoringAgentProcessAlertConfigArgs>>? = null

    private var groupId: Output<String>? = null

    private var matchExpressFilterRelation: Output<String>? = null

    private var matchExpresses: Output<List<ServiceGroupMonitoringAgentProcessMatchExpressArgs>>? =
        null

    private var processName: Output<String>? = null

    /**
     * @param value The alert rule configurations. See `alert_config` below.
     */
    @JvmName("plpkobhmylrxnhxf")
    public suspend fun alertConfigs(`value`: Output<List<ServiceGroupMonitoringAgentProcessAlertConfigArgs>>) {
        this.alertConfigs = value
    }

    @JvmName("nafqxmvutsfdgxkt")
    public suspend fun alertConfigs(vararg values: Output<ServiceGroupMonitoringAgentProcessAlertConfigArgs>) {
        this.alertConfigs = Output.all(values.asList())
    }

    /**
     * @param values The alert rule configurations. See `alert_config` below.
     */
    @JvmName("mlefedtmyockvfja")
    public suspend fun alertConfigs(values: List<Output<ServiceGroupMonitoringAgentProcessAlertConfigArgs>>) {
        this.alertConfigs = Output.all(values)
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("ybpatvcoyyudfypi")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The logical operator used between conditional expressions that are used to match instances. Valid values: `all`, `and`, `or`.
     */
    @JvmName("seoebauumsxoigdu")
    public suspend fun matchExpressFilterRelation(`value`: Output<String>) {
        this.matchExpressFilterRelation = value
    }

    /**
     * @param value The expressions used to match instances. See `match_express` below.
     */
    @JvmName("xbdpmwqhlhxwholq")
    public suspend fun matchExpresses(`value`: Output<List<ServiceGroupMonitoringAgentProcessMatchExpressArgs>>) {
        this.matchExpresses = value
    }

    @JvmName("feiqykaeeleqlhvf")
    public suspend fun matchExpresses(vararg values: Output<ServiceGroupMonitoringAgentProcessMatchExpressArgs>) {
        this.matchExpresses = Output.all(values.asList())
    }

    /**
     * @param values The expressions used to match instances. See `match_express` below.
     */
    @JvmName("vxlrheiaolbdapub")
    public suspend fun matchExpresses(values: List<Output<ServiceGroupMonitoringAgentProcessMatchExpressArgs>>) {
        this.matchExpresses = Output.all(values)
    }

    /**
     * @param value The name of the process.
     */
    @JvmName("ldgcxyitdyntchvs")
    public suspend fun processName(`value`: Output<String>) {
        this.processName = value
    }

    /**
     * @param value The alert rule configurations. See `alert_config` below.
     */
    @JvmName("ntuxvwuigaxqinan")
    public suspend fun alertConfigs(`value`: List<ServiceGroupMonitoringAgentProcessAlertConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert rule configurations. See `alert_config` below.
     */
    @JvmName("yaoikiabrbqeghxp")
    public suspend fun alertConfigs(argument: List<suspend ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert rule configurations. See `alert_config` below.
     */
    @JvmName("dfewpyubufnlhifi")
    public suspend fun alertConfigs(vararg argument: suspend ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert rule configurations. See `alert_config` below.
     */
    @JvmName("okelyfhglicxnknk")
    public suspend fun alertConfigs(argument: suspend ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param values The alert rule configurations. See `alert_config` below.
     */
    @JvmName("uvcawddfgjkvegfs")
    public suspend fun alertConfigs(vararg values: ServiceGroupMonitoringAgentProcessAlertConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertConfigs = mapped
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("xnvqcbaonteiiprd")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The logical operator used between conditional expressions that are used to match instances. Valid values: `all`, `and`, `or`.
     */
    @JvmName("jngspakeaskqmmpk")
    public suspend fun matchExpressFilterRelation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpressFilterRelation = mapped
    }

    /**
     * @param value The expressions used to match instances. See `match_express` below.
     */
    @JvmName("lrjsbehrqfgabuov")
    public suspend fun matchExpresses(`value`: List<ServiceGroupMonitoringAgentProcessMatchExpressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpresses = mapped
    }

    /**
     * @param argument The expressions used to match instances. See `match_express` below.
     */
    @JvmName("mheupenqfupxpilc")
    public suspend fun matchExpresses(argument: List<suspend ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param argument The expressions used to match instances. See `match_express` below.
     */
    @JvmName("skdhvqbijxvrdiwt")
    public suspend fun matchExpresses(vararg argument: suspend ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param argument The expressions used to match instances. See `match_express` below.
     */
    @JvmName("tfpkjuoynvwmgrtk")
    public suspend fun matchExpresses(argument: suspend ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param values The expressions used to match instances. See `match_express` below.
     */
    @JvmName("oqcpwbjmfqgvfiag")
    public suspend fun matchExpresses(vararg values: ServiceGroupMonitoringAgentProcessMatchExpressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchExpresses = mapped
    }

    /**
     * @param value The name of the process.
     */
    @JvmName("vyhjnbjqgvugktnt")
    public suspend fun processName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processName = mapped
    }

    internal fun build(): ServiceGroupMonitoringAgentProcessArgs =
        ServiceGroupMonitoringAgentProcessArgs(
            alertConfigs = alertConfigs,
            groupId = groupId,
            matchExpressFilterRelation = matchExpressFilterRelation,
            matchExpresses = matchExpresses,
            processName = processName,
        )
}
