@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceHybridDoubleWrite].
 */
@PulumiTagMarker
public class ServiceHybridDoubleWriteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceHybridDoubleWriteArgs = ServiceHybridDoubleWriteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceHybridDoubleWriteArgsBuilder.() -> Unit) {
        val builder = ServiceHybridDoubleWriteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceHybridDoubleWrite {
        val builtJavaResource =
            com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceHybridDoubleWrite(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Hybrid Double Write resource.
 * For information about Cloud Monitor Service Hybrid Double Write and how to use it, see [What is Hybrid Double Write](https://next.api.alibabacloud.com/document/Cms/2018-03-08/CreateHybridDoubleWrite).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getAccount({});
 * const source = new alicloud.cms.Namespace("source", {namespace: name});
 * const defaultNamespace = new alicloud.cms.Namespace("default", {namespace: `${name}-source`});
 * const defaultServiceHybridDoubleWrite = new alicloud.cloudmonitor.ServiceHybridDoubleWrite("default", {
 *     sourceNamespace: source.id,
 *     sourceUserId: _default.then(_default => _default.id),
 *     namespace: defaultNamespace.id,
 *     userId: _default.then(_default => _default.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_account()
 * source = alicloud.cms.Namespace("source", namespace=name)
 * default_namespace = alicloud.cms.Namespace("default", namespace=f"{name}-source")
 * default_service_hybrid_double_write = alicloud.cloudmonitor.ServiceHybridDoubleWrite("default",
 *     source_namespace=source.id,
 *     source_user_id=default.id,
 *     namespace=default_namespace.id,
 *     user_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var source = new AliCloud.Cms.Namespace("source", new()
 *     {
 *         NamespaceName = name,
 *     });
 *     var defaultNamespace = new AliCloud.Cms.Namespace("default", new()
 *     {
 *         NamespaceName = $"{name}-source",
 *     });
 *     var defaultServiceHybridDoubleWrite = new AliCloud.CloudMonitor.ServiceHybridDoubleWrite("default", new()
 *     {
 *         SourceNamespace = source.Id,
 *         SourceUserId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         Namespace = defaultNamespace.Id,
 *         UserId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudmonitor"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		source, err := cms.NewNamespace(ctx, "source", &cms.NamespaceArgs{
 * 			Namespace: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNamespace, err := cms.NewNamespace(ctx, "default", &cms.NamespaceArgs{
 * 			Namespace: pulumi.Sprintf("%v-source", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudmonitor.NewServiceHybridDoubleWrite(ctx, "default", &cloudmonitor.ServiceHybridDoubleWriteArgs{
 * 			SourceNamespace: source.ID(),
 * 			SourceUserId:    pulumi.String(_default.Id),
 * 			Namespace:       defaultNamespace.ID(),
 * 			UserId:          pulumi.String(_default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.cms.Namespace;
 * import com.pulumi.alicloud.cms.NamespaceArgs;
 * import com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite;
 * import com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWriteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getAccount();
 *         var source = new Namespace("source", NamespaceArgs.builder()
 *             .namespace(name)
 *             .build());
 *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
 *             .namespace(String.format("%s-source", name))
 *             .build());
 *         var defaultServiceHybridDoubleWrite = new ServiceHybridDoubleWrite("defaultServiceHybridDoubleWrite", ServiceHybridDoubleWriteArgs.builder()
 *             .sourceNamespace(source.id())
 *             .sourceUserId(default_.id())
 *             .namespace(defaultNamespace.id())
 *             .userId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   source:
 *     type: alicloud:cms:Namespace
 *     properties:
 *       namespace: ${name}
 *   defaultNamespace:
 *     type: alicloud:cms:Namespace
 *     name: default
 *     properties:
 *       namespace: ${name}-source
 *   defaultServiceHybridDoubleWrite:
 *     type: alicloud:cloudmonitor:ServiceHybridDoubleWrite
 *     name: default
 *     properties:
 *       sourceNamespace: ${source.id}
 *       sourceUserId: ${default.id}
 *       namespace: ${defaultNamespace.id}
 *       userId: ${default.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Hybrid Double Write can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudmonitor/serviceHybridDoubleWrite:ServiceHybridDoubleWrite example <source_namespace>:<source_user_id>
 * ```
 */
public class ServiceHybridDoubleWrite internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite,
) : KotlinCustomResource(javaResource, ServiceHybridDoubleWriteMapper) {
    /**
     * Target Namespace.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * Source Namespace.
     */
    public val sourceNamespace: Output<String>
        get() = javaResource.sourceNamespace().applyValue({ args0 -> args0 })

    /**
     * Source UserId.
     */
    public val sourceUserId: Output<String>
        get() = javaResource.sourceUserId().applyValue({ args0 -> args0 })

    /**
     * Target UserId.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object ServiceHybridDoubleWriteMapper : ResourceMapper<ServiceHybridDoubleWrite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite::class == javaResource::class

    override fun map(javaResource: Resource): ServiceHybridDoubleWrite =
        ServiceHybridDoubleWrite(
            javaResource as
                com.pulumi.alicloud.cloudmonitor.ServiceHybridDoubleWrite,
        )
}

/**
 * @see [ServiceHybridDoubleWrite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceHybridDoubleWrite].
 */
public suspend fun serviceHybridDoubleWrite(
    name: String,
    block: suspend ServiceHybridDoubleWriteResourceBuilder.() -> Unit,
): ServiceHybridDoubleWrite {
    val builder = ServiceHybridDoubleWriteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceHybridDoubleWrite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceHybridDoubleWrite(name: String): ServiceHybridDoubleWrite {
    val builder = ServiceHybridDoubleWriteResourceBuilder()
    builder.name(name)
    return builder.build()
}
