@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.inputs

import com.pulumi.alicloud.cloudmonitor.inputs.GetServiceHybridDoubleWritesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceHybridDoubleWrites.
 * @property ids A list of Hybrid Double Write IDs.
 * @property namespace Target Namespace.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property sourceNamespace Source Namespace.
 * @property sourceUserId Source UserId.
 * @property userId Target UserId.
 */
public data class GetServiceHybridDoubleWritesPlainArgs(
    public val ids: List<String>? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val sourceNamespace: String? = null,
    public val sourceUserId: String? = null,
    public val userId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudmonitor.inputs.GetServiceHybridDoubleWritesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudmonitor.inputs.GetServiceHybridDoubleWritesPlainArgs =
        com.pulumi.alicloud.cloudmonitor.inputs.GetServiceHybridDoubleWritesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sourceNamespace(sourceNamespace?.let({ args0 -> args0 }))
            .sourceUserId(sourceUserId?.let({ args0 -> args0 }))
            .userId(userId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceHybridDoubleWritesPlainArgs].
 */
@PulumiTagMarker
public class GetServiceHybridDoubleWritesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    private var sourceNamespace: String? = null

    private var sourceUserId: String? = null

    private var userId: String? = null

    /**
     * @param value A list of Hybrid Double Write IDs.
     */
    @JvmName("mdbfsobtkihobvxr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Hybrid Double Write IDs.
     */
    @JvmName("uusjbrwfjtohdkqc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Target Namespace.
     */
    @JvmName("xigbvprofwkpjvrc")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dgqivmpskwyhgydv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Source Namespace.
     */
    @JvmName("aebglhwshcjdsvpx")
    public suspend fun sourceNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceNamespace = mapped
    }

    /**
     * @param value Source UserId.
     */
    @JvmName("jxgaedscuccllocu")
    public suspend fun sourceUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceUserId = mapped
    }

    /**
     * @param value Target UserId.
     */
    @JvmName("qssxhdtxkvikxisp")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetServiceHybridDoubleWritesPlainArgs =
        GetServiceHybridDoubleWritesPlainArgs(
            ids = ids,
            namespace = namespace,
            outputFile = outputFile,
            sourceNamespace = sourceNamespace,
            sourceUserId = sourceUserId,
            userId = userId,
        )
}
