@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.inputs

import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The operator that is used to compare the metric value with the threshold. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
 * @property effectiveInterval The time period during which the alert rule is effective.
 * @property escalationsLevel The alert level. Valid values: `critical`, `warn`, `info`.
 * @property silenceTime The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds.
 * @property statistics The statistical method for alerts. Valid values: `Average`.
 * @property targetLists The alert triggers. See `target_list` below.
 * @property threshold The alert threshold.
 * @property times The number of times for which the threshold can be consecutively exceeded.
 * @property webhook The callback URL.
 */
public data class ServiceGroupMonitoringAgentProcessAlertConfigArgs(
    public val comparisonOperator: Output<String>,
    public val effectiveInterval: Output<String>? = null,
    public val escalationsLevel: Output<String>,
    public val silenceTime: Output<Int>? = null,
    public val statistics: Output<String>,
    public val targetLists: Output<List<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>>? =
        null,
    public val threshold: Output<String>,
    public val times: Output<String>,
    public val webhook: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs =
        com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .effectiveInterval(effectiveInterval?.applyValue({ args0 -> args0 }))
            .escalationsLevel(escalationsLevel.applyValue({ args0 -> args0 }))
            .silenceTime(silenceTime?.applyValue({ args0 -> args0 }))
            .statistics(statistics.applyValue({ args0 -> args0 }))
            .targetLists(
                targetLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .times(times.applyValue({ args0 -> args0 }))
            .webhook(webhook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceGroupMonitoringAgentProcessAlertConfigArgs].
 */
@PulumiTagMarker
public class ServiceGroupMonitoringAgentProcessAlertConfigArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var effectiveInterval: Output<String>? = null

    private var escalationsLevel: Output<String>? = null

    private var silenceTime: Output<Int>? = null

    private var statistics: Output<String>? = null

    private var targetLists:
        Output<List<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>>? = null

    private var threshold: Output<String>? = null

    private var times: Output<String>? = null

    private var webhook: Output<String>? = null

    /**
     * @param value The operator that is used to compare the metric value with the threshold. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
     */
    @JvmName("nfkamudgdvhtpgqf")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The time period during which the alert rule is effective.
     */
    @JvmName("dkvdxrhsdorrwncl")
    public suspend fun effectiveInterval(`value`: Output<String>) {
        this.effectiveInterval = value
    }

    /**
     * @param value The alert level. Valid values: `critical`, `warn`, `info`.
     */
    @JvmName("icwrdgxrwhqmjmed")
    public suspend fun escalationsLevel(`value`: Output<String>) {
        this.escalationsLevel = value
    }

    /**
     * @param value The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds.
     */
    @JvmName("mrranytjuiunnoyt")
    public suspend fun silenceTime(`value`: Output<Int>) {
        this.silenceTime = value
    }

    /**
     * @param value The statistical method for alerts. Valid values: `Average`.
     */
    @JvmName("jtuoxvqiubppoque")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value The alert triggers. See `target_list` below.
     */
    @JvmName("rxiouhnkbnqgjjad")
    public suspend fun targetLists(`value`: Output<List<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>>) {
        this.targetLists = value
    }

    @JvmName("ygddajkxdiiwmkig")
    public suspend fun targetLists(vararg values: Output<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>) {
        this.targetLists = Output.all(values.asList())
    }

    /**
     * @param values The alert triggers. See `target_list` below.
     */
    @JvmName("anhrpimndrrghlic")
    public suspend fun targetLists(values: List<Output<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>>) {
        this.targetLists = Output.all(values)
    }

    /**
     * @param value The alert threshold.
     */
    @JvmName("nasowueiluxxdhin")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value The number of times for which the threshold can be consecutively exceeded.
     */
    @JvmName("aixpvapdsighuaye")
    public suspend fun times(`value`: Output<String>) {
        this.times = value
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("bbsafjyublcjrgjb")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The operator that is used to compare the metric value with the threshold. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
     */
    @JvmName("gxexksstprlhgjnq")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The time period during which the alert rule is effective.
     */
    @JvmName("hfbvrorclcymfsih")
    public suspend fun effectiveInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveInterval = mapped
    }

    /**
     * @param value The alert level. Valid values: `critical`, `warn`, `info`.
     */
    @JvmName("qhucoyfnntrhwouh")
    public suspend fun escalationsLevel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.escalationsLevel = mapped
    }

    /**
     * @param value The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds.
     */
    @JvmName("fflgeriboriknica")
    public suspend fun silenceTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.silenceTime = mapped
    }

    /**
     * @param value The statistical method for alerts. Valid values: `Average`.
     */
    @JvmName("bbvyblacndbschin")
    public suspend fun statistics(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value The alert triggers. See `target_list` below.
     */
    @JvmName("cjoyahoyjadavhjn")
    public suspend fun targetLists(`value`: List<ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetLists = mapped
    }

    /**
     * @param argument The alert triggers. See `target_list` below.
     */
    @JvmName("vlncmiciqkmlntmr")
    public suspend fun targetLists(argument: List<suspend ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetLists = mapped
    }

    /**
     * @param argument The alert triggers. See `target_list` below.
     */
    @JvmName("mesxknayuxlnsfmv")
    public suspend fun targetLists(vararg argument: suspend ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetLists = mapped
    }

    /**
     * @param argument The alert triggers. See `target_list` below.
     */
    @JvmName("eputexfdawrppwwd")
    public suspend fun targetLists(argument: suspend ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.targetLists = mapped
    }

    /**
     * @param values The alert triggers. See `target_list` below.
     */
    @JvmName("najhnqeiofdrmrfv")
    public suspend fun targetLists(vararg values: ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetLists = mapped
    }

    /**
     * @param value The alert threshold.
     */
    @JvmName("lxucfwhcfycapopd")
    public suspend fun threshold(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The number of times for which the threshold can be consecutively exceeded.
     */
    @JvmName("dxlwyrllyvklaojx")
    public suspend fun times(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.times = mapped
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("drvoregxnpvedmts")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    internal fun build(): ServiceGroupMonitoringAgentProcessAlertConfigArgs =
        ServiceGroupMonitoringAgentProcessAlertConfigArgs(
            comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
            effectiveInterval = effectiveInterval,
            escalationsLevel = escalationsLevel ?: throw PulumiNullFieldException("escalationsLevel"),
            silenceTime = silenceTime,
            statistics = statistics ?: throw PulumiNullFieldException("statistics"),
            targetLists = targetLists,
            threshold = threshold ?: throw PulumiNullFieldException("threshold"),
            times = times ?: throw PulumiNullFieldException("times"),
            webhook = webhook,
        )
}
