@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.inputs

import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the resource.
 * @property jsonParams The parameters of the alert callback. Specify the parameters in the JSON format.
 * @property level The alert level. Valid values: `CRITICAL`, `WARN`, `INFO`.
 * @property targetListId The ID of the resource for which alerts are triggered.
 */
public data class ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs(
    public val arn: Output<String>? = null,
    public val jsonParams: Output<String>? = null,
    public val level: Output<String>? = null,
    public val targetListId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs =
        com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .jsonParams(jsonParams?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .targetListId(targetListId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs].
 */
@PulumiTagMarker
public class ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var jsonParams: Output<String>? = null

    private var level: Output<String>? = null

    private var targetListId: Output<String>? = null

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the resource.
     */
    @JvmName("wirnmowdfntilfwd")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The parameters of the alert callback. Specify the parameters in the JSON format.
     */
    @JvmName("uhegvleykejmfljc")
    public suspend fun jsonParams(`value`: Output<String>) {
        this.jsonParams = value
    }

    /**
     * @param value The alert level. Valid values: `CRITICAL`, `WARN`, `INFO`.
     */
    @JvmName("dyxhlwelxbenblpq")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The ID of the resource for which alerts are triggered.
     */
    @JvmName("tbqvgplynycguprf")
    public suspend fun targetListId(`value`: Output<String>) {
        this.targetListId = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the resource.
     */
    @JvmName("aioifqodcviisddu")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The parameters of the alert callback. Specify the parameters in the JSON format.
     */
    @JvmName("vxcresqxeodwatfi")
    public suspend fun jsonParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonParams = mapped
    }

    /**
     * @param value The alert level. Valid values: `CRITICAL`, `WARN`, `INFO`.
     */
    @JvmName("giswjepkdqqswytb")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The ID of the resource for which alerts are triggered.
     */
    @JvmName("lqtnsypwmdnugtag")
    public suspend fun targetListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetListId = mapped
    }

    internal fun build(): ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs =
        ServiceGroupMonitoringAgentProcessAlertConfigTargetListArgs(
            arn = arn,
            jsonParams = jsonParams,
            level = level,
            targetListId = targetListId,
        )
}
