@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.inputs

import com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property function The matching condition. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
 * @property name The criteria based on which the instances are matched.
 * @property value The keyword used to match the instance name.
 */
public data class ServiceGroupMonitoringAgentProcessMatchExpressArgs(
    public val function: Output<String>? = null,
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs =
        com.pulumi.alicloud.cloudmonitor.inputs.ServiceGroupMonitoringAgentProcessMatchExpressArgs.builder()
            .function(function?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceGroupMonitoringAgentProcessMatchExpressArgs].
 */
@PulumiTagMarker
public class ServiceGroupMonitoringAgentProcessMatchExpressArgsBuilder internal constructor() {
    private var function: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The matching condition. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
     */
    @JvmName("rjvrsdixfmxehats")
    public suspend fun function(`value`: Output<String>) {
        this.function = value
    }

    /**
     * @param value The criteria based on which the instances are matched.
     */
    @JvmName("cvdvcvfnsiekvtww")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The keyword used to match the instance name.
     */
    @JvmName("vknkqaasmyhphedy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The matching condition. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
     */
    @JvmName("rouvvlersndjlepf")
    public suspend fun function(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value The criteria based on which the instances are matched.
     */
    @JvmName("sryucmqkyycaktwj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The keyword used to match the instance name.
     */
    @JvmName("htamitgauevwjvrv")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ServiceGroupMonitoringAgentProcessMatchExpressArgs =
        ServiceGroupMonitoringAgentProcessMatchExpressArgs(
            function = function,
            name = name,
            `value` = `value`,
        )
}
