@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Hybrid Double Write. It formats as `<source_namespace>:<source_user_id>`.
 * @property namespace Target Namespace.
 * @property sourceNamespace Source Namespace.
 * @property sourceUserId Source UserId.
 * @property userId Target UserId.
 */
public data class GetServiceHybridDoubleWritesHybridDoubleWrite(
    public val id: String,
    public val namespace: String,
    public val sourceNamespace: String,
    public val sourceUserId: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudmonitor.outputs.GetServiceHybridDoubleWritesHybridDoubleWrite): GetServiceHybridDoubleWritesHybridDoubleWrite =
            GetServiceHybridDoubleWritesHybridDoubleWrite(
                id = javaType.id(),
                namespace = javaType.namespace(),
                sourceNamespace = javaType.sourceNamespace(),
                sourceUserId = javaType.sourceUserId(),
                userId = javaType.userId(),
            )
    }
}
