@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServiceHybridDoubleWrites.
 * @property hybridDoubleWrites A list of Hybrid Double Writes. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property namespace Target Namespace.
 * @property outputFile
 * @property sourceNamespace Source Namespace.
 * @property sourceUserId Source UserId.
 * @property userId Target UserId.
 */
public data class GetServiceHybridDoubleWritesResult(
    public val hybridDoubleWrites: List<GetServiceHybridDoubleWritesHybridDoubleWrite>,
    public val id: String,
    public val ids: List<String>,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val sourceNamespace: String? = null,
    public val sourceUserId: String? = null,
    public val userId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudmonitor.outputs.GetServiceHybridDoubleWritesResult): GetServiceHybridDoubleWritesResult = GetServiceHybridDoubleWritesResult(
            hybridDoubleWrites = javaType.hybridDoubleWrites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudmonitor.kotlin.outputs.GetServiceHybridDoubleWritesHybridDoubleWrite.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sourceNamespace = javaType.sourceNamespace().map({ args0 -> args0 }).orElse(null),
            sourceUserId = javaType.sourceUserId().map({ args0 -> args0 }).orElse(null),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
