@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparisonOperator The operator that is used to compare the metric value with the threshold. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
 * @property effectiveInterval The time period during which the alert rule is effective.
 * @property escalationsLevel The alert level. Valid values: `critical`, `warn`, `info`.
 * @property silenceTime The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds.
 * @property statistics The statistical method for alerts. Valid values: `Average`.
 * @property targetLists The alert triggers. See `target_list` below.
 * @property threshold The alert threshold.
 * @property times The number of times for which the threshold can be consecutively exceeded.
 * @property webhook The callback URL.
 */
public data class ServiceGroupMonitoringAgentProcessAlertConfig(
    public val comparisonOperator: String,
    public val effectiveInterval: String? = null,
    public val escalationsLevel: String,
    public val silenceTime: Int? = null,
    public val statistics: String,
    public val targetLists: List<ServiceGroupMonitoringAgentProcessAlertConfigTargetList>? = null,
    public val threshold: String,
    public val times: String,
    public val webhook: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudmonitor.outputs.ServiceGroupMonitoringAgentProcessAlertConfig): ServiceGroupMonitoringAgentProcessAlertConfig =
            ServiceGroupMonitoringAgentProcessAlertConfig(
                comparisonOperator = javaType.comparisonOperator(),
                effectiveInterval = javaType.effectiveInterval().map({ args0 -> args0 }).orElse(null),
                escalationsLevel = javaType.escalationsLevel(),
                silenceTime = javaType.silenceTime().map({ args0 -> args0 }).orElse(null),
                statistics = javaType.statistics(),
                targetLists = javaType.targetLists().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cloudmonitor.kotlin.outputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetList.Companion.toKotlin(args0)
                    })
                }),
                threshold = javaType.threshold(),
                times = javaType.times(),
                webhook = javaType.webhook().map({ args0 -> args0 }).orElse(null),
            )
    }
}
