@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudmonitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the resource.
 * @property jsonParams The parameters of the alert callback. Specify the parameters in the JSON format.
 * @property level The alert level. Valid values: `CRITICAL`, `WARN`, `INFO`.
 * @property targetListId The ID of the resource for which alerts are triggered.
 */
public data class ServiceGroupMonitoringAgentProcessAlertConfigTargetList(
    public val arn: String? = null,
    public val jsonParams: String? = null,
    public val level: String? = null,
    public val targetListId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudmonitor.outputs.ServiceGroupMonitoringAgentProcessAlertConfigTargetList): ServiceGroupMonitoringAgentProcessAlertConfigTargetList =
            ServiceGroupMonitoringAgentProcessAlertConfigTargetList(
                arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
                jsonParams = javaType.jsonParams().map({ args0 -> args0 }).orElse(null),
                level = javaType.level().map({ args0 -> args0 }).orElse(null),
                targetListId = javaType.targetListId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
