@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.kotlin.outputs.AccessConfigurationPermissionPolicy
import com.pulumi.alicloud.cloudsso.kotlin.outputs.AccessConfigurationPermissionPolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AccessConfiguration].
 */
@PulumiTagMarker
public class AccessConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessConfigurationArgs = AccessConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessConfigurationArgsBuilder.() -> Unit) {
        val builder = AccessConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessConfiguration {
        val builtJavaResource =
            com.pulumi.alicloud.cloudsso.AccessConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessConfiguration(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO Access Configuration resource.
 * For information about Cloud SSO Access Configuration and how to use it, see [What is Access Configuration](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createaccessconfiguration).
 * > **NOTE:** Available since v1.145.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO Access Configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessConfiguration:AccessConfiguration example <directory_id>:<access_configuration_id>
 * ```
 */
public class AccessConfiguration internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.AccessConfiguration,
) : KotlinCustomResource(javaResource, AccessConfigurationMapper) {
    /**
     * The AccessConfigurationId of the Access Configuration.
     */
    public val accessConfigurationId: Output<String>
        get() = javaResource.accessConfigurationId().applyValue({ args0 -> args0 })

    /**
     * The AccessConfigurationName of the Access Configuration. The name of the resource. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
     */
    public val accessConfigurationName: Output<String>
        get() = javaResource.accessConfigurationName().applyValue({ args0 -> args0 })

    /**
     * The Description of the  Access Configuration. The description can be up to `1024` characters long.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * This parameter is used to force deletion `permission_policies`. Valid Value: `true` and `false`.
     * * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
     */
    public val forceRemovePermissionPolicies: Output<Boolean>?
        get() = javaResource.forceRemovePermissionPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Policy List. See `permission_policies` below.
     */
    public val permissionPolicies: Output<List<AccessConfigurationPermissionPolicy>>?
        get() = javaResource.permissionPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
     */
    public val relayState: Output<String>?
        get() = javaResource.relayState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SessionDuration of the Access Configuration. Valid Value: `900` to `43200`. Unit: Seconds.
     */
    public val sessionDuration: Output<Int>
        get() = javaResource.sessionDuration().applyValue({ args0 -> args0 })
}

public object AccessConfigurationMapper : ResourceMapper<AccessConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.AccessConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): AccessConfiguration = AccessConfiguration(
        javaResource
            as com.pulumi.alicloud.cloudsso.AccessConfiguration,
    )
}

/**
 * @see [AccessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessConfiguration].
 */
public suspend fun accessConfiguration(
    name: String,
    block: suspend AccessConfigurationResourceBuilder.() -> Unit,
): AccessConfiguration {
    val builder = AccessConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessConfiguration(name: String): AccessConfiguration {
    val builder = AccessConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
