@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.AccessConfigurationArgs.builder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.AccessConfigurationPermissionPolicyArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.AccessConfigurationPermissionPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO Access Configuration resource.
 * For information about Cloud SSO Access Configuration and how to use it, see [What is Access Configuration](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createaccessconfiguration).
 * > **NOTE:** Available since v1.145.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO Access Configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessConfiguration:AccessConfiguration example <directory_id>:<access_configuration_id>
 * ```
 * @property accessConfigurationName The AccessConfigurationName of the Access Configuration. The name of the resource. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
 * @property description The Description of the  Access Configuration. The description can be up to `1024` characters long.
 * @property directoryId The ID of the Directory.
 * @property forceRemovePermissionPolicies This parameter is used to force deletion `permission_policies`. Valid Value: `true` and `false`.
 * * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
 * @property permissionPolicies The Policy List. See `permission_policies` below.
 * @property relayState The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
 * @property sessionDuration The SessionDuration of the Access Configuration. Valid Value: `900` to `43200`. Unit: Seconds.
 */
public data class AccessConfigurationArgs(
    public val accessConfigurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val forceRemovePermissionPolicies: Output<Boolean>? = null,
    public val permissionPolicies: Output<List<AccessConfigurationPermissionPolicyArgs>>? = null,
    public val relayState: Output<String>? = null,
    public val sessionDuration: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.AccessConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.AccessConfigurationArgs =
        com.pulumi.alicloud.cloudsso.AccessConfigurationArgs.builder()
            .accessConfigurationName(accessConfigurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .forceRemovePermissionPolicies(forceRemovePermissionPolicies?.applyValue({ args0 -> args0 }))
            .permissionPolicies(
                permissionPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .relayState(relayState?.applyValue({ args0 -> args0 }))
            .sessionDuration(sessionDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessConfigurationArgs].
 */
@PulumiTagMarker
public class AccessConfigurationArgsBuilder internal constructor() {
    private var accessConfigurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var forceRemovePermissionPolicies: Output<Boolean>? = null

    private var permissionPolicies: Output<List<AccessConfigurationPermissionPolicyArgs>>? = null

    private var relayState: Output<String>? = null

    private var sessionDuration: Output<Int>? = null

    /**
     * @param value The AccessConfigurationName of the Access Configuration. The name of the resource. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
     */
    @JvmName("ojerhhuyqheinyut")
    public suspend fun accessConfigurationName(`value`: Output<String>) {
        this.accessConfigurationName = value
    }

    /**
     * @param value The Description of the  Access Configuration. The description can be up to `1024` characters long.
     */
    @JvmName("euwxnllgsrxcmdam")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("tftrofbcywjvbtqp")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value This parameter is used to force deletion `permission_policies`. Valid Value: `true` and `false`.
     * * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
     */
    @JvmName("lwbodtuxpseyihhd")
    public suspend fun forceRemovePermissionPolicies(`value`: Output<Boolean>) {
        this.forceRemovePermissionPolicies = value
    }

    /**
     * @param value The Policy List. See `permission_policies` below.
     */
    @JvmName("iafnhslektsuuqcd")
    public suspend fun permissionPolicies(`value`: Output<List<AccessConfigurationPermissionPolicyArgs>>) {
        this.permissionPolicies = value
    }

    @JvmName("spsbfrglcciqgqef")
    public suspend fun permissionPolicies(vararg values: Output<AccessConfigurationPermissionPolicyArgs>) {
        this.permissionPolicies = Output.all(values.asList())
    }

    /**
     * @param values The Policy List. See `permission_policies` below.
     */
    @JvmName("gwqrajgukiemuneh")
    public suspend fun permissionPolicies(values: List<Output<AccessConfigurationPermissionPolicyArgs>>) {
        this.permissionPolicies = Output.all(values)
    }

    /**
     * @param value The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
     */
    @JvmName("wssodaultifiscqw")
    public suspend fun relayState(`value`: Output<String>) {
        this.relayState = value
    }

    /**
     * @param value The SessionDuration of the Access Configuration. Valid Value: `900` to `43200`. Unit: Seconds.
     */
    @JvmName("ffevarcjcbxaqeku")
    public suspend fun sessionDuration(`value`: Output<Int>) {
        this.sessionDuration = value
    }

    /**
     * @param value The AccessConfigurationName of the Access Configuration. The name of the resource. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
     */
    @JvmName("nboqqnwjhokiwsso")
    public suspend fun accessConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessConfigurationName = mapped
    }

    /**
     * @param value The Description of the  Access Configuration. The description can be up to `1024` characters long.
     */
    @JvmName("xsvuigylnqdwsneh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("xeteokiriqmmsydg")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value This parameter is used to force deletion `permission_policies`. Valid Value: `true` and `false`.
     * * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
     */
    @JvmName("fatyqokwagrvduhe")
    public suspend fun forceRemovePermissionPolicies(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceRemovePermissionPolicies = mapped
    }

    /**
     * @param value The Policy List. See `permission_policies` below.
     */
    @JvmName("lpbtipqbptybubco")
    public suspend fun permissionPolicies(`value`: List<AccessConfigurationPermissionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionPolicies = mapped
    }

    /**
     * @param argument The Policy List. See `permission_policies` below.
     */
    @JvmName("jvlfqjrcwgriqaii")
    public suspend fun permissionPolicies(argument: List<suspend AccessConfigurationPermissionPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessConfigurationPermissionPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.permissionPolicies = mapped
    }

    /**
     * @param argument The Policy List. See `permission_policies` below.
     */
    @JvmName("briekqsvjlfbcroc")
    public suspend fun permissionPolicies(vararg argument: suspend AccessConfigurationPermissionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessConfigurationPermissionPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.permissionPolicies = mapped
    }

    /**
     * @param argument The Policy List. See `permission_policies` below.
     */
    @JvmName("nfxnopygibfqxmae")
    public suspend fun permissionPolicies(argument: suspend AccessConfigurationPermissionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessConfigurationPermissionPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.permissionPolicies = mapped
    }

    /**
     * @param values The Policy List. See `permission_policies` below.
     */
    @JvmName("jvuyqbmbkohqenar")
    public suspend fun permissionPolicies(vararg values: AccessConfigurationPermissionPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionPolicies = mapped
    }

    /**
     * @param value The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
     */
    @JvmName("lkoqvrobjqkpsqjf")
    public suspend fun relayState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayState = mapped
    }

    /**
     * @param value The SessionDuration of the Access Configuration. Valid Value: `900` to `43200`. Unit: Seconds.
     */
    @JvmName("ovieexodccwhlmms")
    public suspend fun sessionDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionDuration = mapped
    }

    internal fun build(): AccessConfigurationArgs = AccessConfigurationArgs(
        accessConfigurationName = accessConfigurationName,
        description = description,
        directoryId = directoryId,
        forceRemovePermissionPolicies = forceRemovePermissionPolicies,
        permissionPolicies = permissionPolicies,
        relayState = relayState,
        sessionDuration = sessionDuration,
    )
}
