@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessConfigurationProvisioning].
 */
@PulumiTagMarker
public class AccessConfigurationProvisioningResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessConfigurationProvisioningArgs = AccessConfigurationProvisioningArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessConfigurationProvisioningArgsBuilder.() -> Unit) {
        val builder = AccessConfigurationProvisioningArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessConfigurationProvisioning {
        val builtJavaResource =
            com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioning(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessConfigurationProvisioning(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO Access Configuration Provisioning resource.
 * For information about Cloud SSO Access Configuration Provisioning and how to use it, see [What is Access Configuration Provisioning](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addpermissionpolicytoaccessconfiguration).
 * > **NOTE:** Available since v1.148.0.
 * ## Import
 * Cloud SSO Access Configuration Provisioning can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessConfigurationProvisioning:AccessConfigurationProvisioning example <directory_id>:<access_configuration_id>:<target_type>:<target_id>
 * ```
 */
public class AccessConfigurationProvisioning internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioning,
) : KotlinCustomResource(javaResource, AccessConfigurationProvisioningMapper) {
    /**
     * The Access configuration ID.
     */
    public val accessConfigurationId: Output<String>
        get() = javaResource.accessConfigurationId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `Provisioned`, `ReprovisionRequired` and `DeprovisionFailed`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the target to create the resource range.
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })
}

public object AccessConfigurationProvisioningMapper :
    ResourceMapper<AccessConfigurationProvisioning> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioning::class == javaResource::class

    override fun map(javaResource: Resource): AccessConfigurationProvisioning =
        AccessConfigurationProvisioning(
            javaResource as
                com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioning,
        )
}

/**
 * @see [AccessConfigurationProvisioning].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessConfigurationProvisioning].
 */
public suspend fun accessConfigurationProvisioning(
    name: String,
    block: suspend AccessConfigurationProvisioningResourceBuilder.() -> Unit,
): AccessConfigurationProvisioning {
    val builder = AccessConfigurationProvisioningResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessConfigurationProvisioning].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessConfigurationProvisioning(name: String): AccessConfigurationProvisioning {
    val builder = AccessConfigurationProvisioningResourceBuilder()
    builder.name(name)
    return builder.build()
}
