@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO Access Configuration Provisioning resource.
 * For information about Cloud SSO Access Configuration Provisioning and how to use it, see [What is Access Configuration Provisioning](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addpermissionpolicytoaccessconfiguration).
 * > **NOTE:** Available since v1.148.0.
 * ## Import
 * Cloud SSO Access Configuration Provisioning can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessConfigurationProvisioning:AccessConfigurationProvisioning example <directory_id>:<access_configuration_id>:<target_type>:<target_id>
 * ```
 * @property accessConfigurationId The Access configuration ID.
 * @property directoryId The ID of the Directory.
 * @property status The status of the resource. Valid values: `Provisioned`, `ReprovisionRequired` and `DeprovisionFailed`.
 * @property targetId The ID of the target to create the resource range.
 * @property targetType The type of the resource range target to be accessed. Valid values: `RD-Account`.
 */
public data class AccessConfigurationProvisioningArgs(
    public val accessConfigurationId: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val targetId: Output<String>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioningArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioningArgs =
        com.pulumi.alicloud.cloudsso.AccessConfigurationProvisioningArgs.builder()
            .accessConfigurationId(accessConfigurationId?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessConfigurationProvisioningArgs].
 */
@PulumiTagMarker
public class AccessConfigurationProvisioningArgsBuilder internal constructor() {
    private var accessConfigurationId: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var status: Output<String>? = null

    private var targetId: Output<String>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value The Access configuration ID.
     */
    @JvmName("nokbqfhimsgfrmep")
    public suspend fun accessConfigurationId(`value`: Output<String>) {
        this.accessConfigurationId = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("cpygxkdbxupqfimb")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The status of the resource. Valid values: `Provisioned`, `ReprovisionRequired` and `DeprovisionFailed`.
     */
    @JvmName("oremjhfqykiwfwbb")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the target to create the resource range.
     */
    @JvmName("xwypwinwobbqfpac")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    @JvmName("qvgaqxnlklgjnchl")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value The Access configuration ID.
     */
    @JvmName("ecwyctoqgatsxkgb")
    public suspend fun accessConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessConfigurationId = mapped
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("bcddkikewpesgsvl")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Provisioned`, `ReprovisionRequired` and `DeprovisionFailed`.
     */
    @JvmName("pabhcoaiftxltwhm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The ID of the target to create the resource range.
     */
    @JvmName("xogxnlkxqkjrnpcd")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    /**
     * @param value The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    @JvmName("vhaojmvolqiptsuc")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): AccessConfigurationProvisioningArgs = AccessConfigurationProvisioningArgs(
        accessConfigurationId = accessConfigurationId,
        directoryId = directoryId,
        status = status,
        targetId = targetId,
        targetType = targetType,
    )
}
