@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessManagement].
 */
@PulumiTagMarker
public class AccessManagementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessManagementArgs = AccessManagementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessManagementArgsBuilder.() -> Unit) {
        val builder = AccessManagementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessManagement {
        val builtJavaResource = com.pulumi.alicloud.cloudsso.AccessManagement(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessManagement(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO Access Assignment resource.
 * For information about Cloud SSO Access Assignment and how to use it, see [What is Access Assignment](https://www.alibabacloud.com/help/en/doc-detail/265996.htm).
 * > **NOTE:** When you configure access assignment for the first time, access configuration will be automatically deployed.
 * > **NOTE:** Available since v1.145.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO Access Assignment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessManagement:AccessManagement example <directory_id>:<access_configuration_id>:<target_type>:<target_id>:<principal_type>:<principal_id>
 * ```
 */
public class AccessManagement internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.AccessManagement,
) : KotlinCustomResource(javaResource, AccessManagementMapper) {
    /**
     * The Access configuration ID.
     */
    public val accessConfigurationId: Output<String>
        get() = javaResource.accessConfigurationId().applyValue({ args0 -> args0 })

    /**
     * The deprovision strategy. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation。
     */
    public val deprovisionStrategy: Output<String>?
        get() = javaResource.deprovisionStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The ID of the access assignment.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * The ID of the target to create the resource range.
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })
}

public object AccessManagementMapper : ResourceMapper<AccessManagement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.AccessManagement::class == javaResource::class

    override fun map(javaResource: Resource): AccessManagement = AccessManagement(
        javaResource as
            com.pulumi.alicloud.cloudsso.AccessManagement,
    )
}

/**
 * @see [AccessManagement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessManagement].
 */
public suspend fun accessManagement(
    name: String,
    block: suspend AccessManagementResourceBuilder.() -> Unit,
): AccessManagement {
    val builder = AccessManagementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessManagement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessManagement(name: String): AccessManagement {
    val builder = AccessManagementResourceBuilder()
    builder.name(name)
    return builder.build()
}
