@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.AccessManagementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO Access Assignment resource.
 * For information about Cloud SSO Access Assignment and how to use it, see [What is Access Assignment](https://www.alibabacloud.com/help/en/doc-detail/265996.htm).
 * > **NOTE:** When you configure access assignment for the first time, access configuration will be automatically deployed.
 * > **NOTE:** Available since v1.145.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO Access Assignment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/accessManagement:AccessManagement example <directory_id>:<access_configuration_id>:<target_type>:<target_id>:<principal_type>:<principal_id>
 * ```
 * @property accessConfigurationId The Access configuration ID.
 * @property deprovisionStrategy The deprovision strategy. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation。
 * @property directoryId The ID of the Directory.
 * @property principalId The ID of the access assignment.
 * @property principalType The identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
 * @property targetId The ID of the target to create the resource range.
 * @property targetType The type of the resource range target to be accessed. Valid values: `RD-Account`.
 */
public data class AccessManagementArgs(
    public val accessConfigurationId: Output<String>? = null,
    public val deprovisionStrategy: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<String>? = null,
    public val targetId: Output<String>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.AccessManagementArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.AccessManagementArgs =
        com.pulumi.alicloud.cloudsso.AccessManagementArgs.builder()
            .accessConfigurationId(accessConfigurationId?.applyValue({ args0 -> args0 }))
            .deprovisionStrategy(deprovisionStrategy?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(principalType?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessManagementArgs].
 */
@PulumiTagMarker
public class AccessManagementArgsBuilder internal constructor() {
    private var accessConfigurationId: Output<String>? = null

    private var deprovisionStrategy: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<String>? = null

    private var targetId: Output<String>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value The Access configuration ID.
     */
    @JvmName("coqjpvjivfhseagg")
    public suspend fun accessConfigurationId(`value`: Output<String>) {
        this.accessConfigurationId = value
    }

    /**
     * @param value The deprovision strategy. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation。
     */
    @JvmName("ntshtnoivjipgval")
    public suspend fun deprovisionStrategy(`value`: Output<String>) {
        this.deprovisionStrategy = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("ekspexkqqyybdngp")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The ID of the access assignment.
     */
    @JvmName("wvhkdodckppghwws")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
     */
    @JvmName("rsehhpgxmabjxido")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value The ID of the target to create the resource range.
     */
    @JvmName("nrqcqxiywqhotjgs")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    @JvmName("bccmwnhlyktimuej")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value The Access configuration ID.
     */
    @JvmName("fylsqhnkbuujwxmq")
    public suspend fun accessConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessConfigurationId = mapped
    }

    /**
     * @param value The deprovision strategy. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation。
     */
    @JvmName("dppquktjmsgcokrq")
    public suspend fun deprovisionStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprovisionStrategy = mapped
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("awmqvchfnngtvyxf")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The ID of the access assignment.
     */
    @JvmName("ajdscdvgmhddglcm")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
     */
    @JvmName("hadadapdwqdaubmp")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The ID of the target to create the resource range.
     */
    @JvmName("mdgldhlkolucnnto")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    /**
     * @param value The type of the resource range target to be accessed. Valid values: `RD-Account`.
     */
    @JvmName("vmiuwsukauclnana")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): AccessManagementArgs = AccessManagementArgs(
        accessConfigurationId = accessConfigurationId,
        deprovisionStrategy = deprovisionStrategy,
        directoryId = directoryId,
        principalId = principalId,
        principalType = principalType,
        targetId = targetId,
        targetType = targetType,
    )
}
