@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getAccessAssignmentsPlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getAccessConfigurationsPlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getDirectoriesPlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getGroupsPlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getScimServerCredentialsPlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getServicePlain
import com.pulumi.alicloud.cloudsso.CloudssoFunctions.getUsersPlain
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetAccessAssignmentsPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetAccessAssignmentsPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetAccessConfigurationsPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetAccessConfigurationsPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetDirectoriesPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetDirectoriesPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetScimServerCredentialsPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetScimServerCredentialsPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessAssignmentsResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessConfigurationsResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetDirectoriesResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetScimServerCredentialsResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessAssignmentsResult.Companion.toKotlin as getAccessAssignmentsResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessConfigurationsResult.Companion.toKotlin as getAccessConfigurationsResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetDirectoriesResult.Companion.toKotlin as getDirectoriesResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetScimServerCredentialsResult.Companion.toKotlin as getScimServerCredentialsResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.cloudsso.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object CloudssoFunctions {
    /**
     * This data source provides the Cloud Sso Access Assignments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.193.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getAccessAssignments({
     *     directoryId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudSsoAccessAssignmentId1 = ids.then(ids => ids.assignments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_access_assignments(directory_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudSsoAccessAssignmentId1", ids.assignments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetAccessAssignments.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoAccessAssignmentId1"] = ids&#46;Apply(getAccessAssignmentsResult => getAccessAssignmentsResult&#46;Assignments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetAccessAssignments(ctx, &cloudsso.GetAccessAssignmentsArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoAccessAssignmentId1", ids.Assignments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetAccessAssignmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getAccessAssignments(GetAccessAssignmentsArgs.builder()
     *             .directoryId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudSsoAccessAssignmentId1", ids.applyValue(getAccessAssignmentsResult -> getAccessAssignmentsResult.assignments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getAccessAssignments
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   cloudSsoAccessAssignmentId1: ${ids.assignments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessAssignments.
     * @return A collection of values returned by getAccessAssignments.
     */
    public suspend fun getAccessAssignments(argument: GetAccessAssignmentsPlainArgs): GetAccessAssignmentsResult =
        getAccessAssignmentsResultToKotlin(getAccessAssignmentsPlain(argument.toJava()).await())

    /**
     * @see [getAccessAssignments].
     * @param accessConfigurationId Access configuration ID.
     * @param directoryId Directory ID.
     * @param ids A list of Access Assignment IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param principalType Create the identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
     * @param targetId The ID of the target to create the resource range.
     * @param targetType The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase. Valid values: `RD-Account`.
     * @return A collection of values returned by getAccessAssignments.
     */
    public suspend fun getAccessAssignments(
        accessConfigurationId: String? = null,
        directoryId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        principalType: String? = null,
        targetId: String? = null,
        targetType: String? = null,
    ): GetAccessAssignmentsResult {
        val argument = GetAccessAssignmentsPlainArgs(
            accessConfigurationId = accessConfigurationId,
            directoryId = directoryId,
            ids = ids,
            outputFile = outputFile,
            principalType = principalType,
            targetId = targetId,
            targetType = targetType,
        )
        return getAccessAssignmentsResultToKotlin(getAccessAssignmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessAssignments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetAccessAssignmentsPlainArgs].
     * @return A collection of values returned by getAccessAssignments.
     */
    public suspend fun getAccessAssignments(argument: suspend GetAccessAssignmentsPlainArgsBuilder.() -> Unit): GetAccessAssignmentsResult {
        val builder = GetAccessAssignmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessAssignmentsResultToKotlin(getAccessAssignmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Sso Access Configurations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getAccessConfigurations({
     *     directoryId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudSsoAccessConfigurationId1 = ids.then(ids => ids.configurations?.[0]?.id);
     * const nameRegex = alicloud.cloudsso.getAccessConfigurations({
     *     directoryId: "example_value",
     *     nameRegex: "^my-AccessConfiguration",
     * });
     * export const cloudSsoAccessConfigurationId2 = nameRegex.then(nameRegex => nameRegex.configurations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_access_configurations(directory_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudSsoAccessConfigurationId1", ids.configurations[0].id)
     * name_regex = alicloud.cloudsso.get_access_configurations(directory_id="example_value",
     *     name_regex="^my-AccessConfiguration")
     * pulumi.export("cloudSsoAccessConfigurationId2", name_regex.configurations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetAccessConfigurations.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudSso.GetAccessConfigurations.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         NameRegex = "^my-AccessConfiguration",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoAccessConfigurationId1"] = ids&#46;Apply(getAccessConfigurationsResult => getAccessConfigurationsResult&#46;Configurations[0]?.Id),
     *         ["cloudSsoAccessConfigurationId2"] = nameRegex&#46;Apply(getAccessConfigurationsResult => getAccessConfigurationsResult&#46;Configurations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetAccessConfigurations(ctx, &cloudsso.GetAccessConfigurationsArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoAccessConfigurationId1", ids.Configurations[0].Id)
     * 		nameRegex, err := cloudsso.GetAccessConfigurations(ctx, &cloudsso.GetAccessConfigurationsArgs{
     * 			DirectoryId: "example_value",
     * 			NameRegex:   pulumi.StringRef("^my-AccessConfiguration"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoAccessConfigurationId2", nameRegex.Configurations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetAccessConfigurationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getAccessConfigurations(GetAccessConfigurationsArgs.builder()
     *             .directoryId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudSsoAccessConfigurationId1", ids.applyValue(getAccessConfigurationsResult -> getAccessConfigurationsResult.configurations()[0].id()));
     *         final var nameRegex = CloudssoFunctions.getAccessConfigurations(GetAccessConfigurationsArgs.builder()
     *             .directoryId("example_value")
     *             .nameRegex("^my-AccessConfiguration")
     *             .build());
     *         ctx.export("cloudSsoAccessConfigurationId2", nameRegex.applyValue(getAccessConfigurationsResult -> getAccessConfigurationsResult.configurations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getAccessConfigurations
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getAccessConfigurations
     *       Arguments:
     *         directoryId: example_value
     *         nameRegex: ^my-AccessConfiguration
     * outputs:
     *   cloudSsoAccessConfigurationId1: ${ids.configurations[0].id}
     *   cloudSsoAccessConfigurationId2: ${nameRegex.configurations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessConfigurations.
     * @return A collection of values returned by getAccessConfigurations.
     */
    public suspend fun getAccessConfigurations(argument: GetAccessConfigurationsPlainArgs): GetAccessConfigurationsResult =
        getAccessConfigurationsResultToKotlin(getAccessConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getAccessConfigurations].
     * @param directoryId The ID of the Directory.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Access Configuration IDs.
     * @param nameRegex A regex string to filter results by Access Configuration name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAccessConfigurations.
     */
    public suspend fun getAccessConfigurations(
        directoryId: String,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAccessConfigurationsResult {
        val argument = GetAccessConfigurationsPlainArgs(
            directoryId = directoryId,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAccessConfigurationsResultToKotlin(getAccessConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetAccessConfigurationsPlainArgs].
     * @return A collection of values returned by getAccessConfigurations.
     */
    public suspend fun getAccessConfigurations(argument: suspend GetAccessConfigurationsPlainArgsBuilder.() -> Unit): GetAccessConfigurationsResult {
        val builder = GetAccessConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessConfigurationsResultToKotlin(getAccessConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Sso Directories of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getDirectories({
     *     ids: ["example_id"],
     * });
     * export const cloudSsoDirectoryId1 = ids.then(ids => ids.directories?.[0]?.id);
     * const nameRegex = alicloud.cloudsso.getDirectories({
     *     nameRegex: "^my-Directory",
     * });
     * export const cloudSsoDirectoryId2 = nameRegex.then(nameRegex => nameRegex.directories?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_directories(ids=["example_id"])
     * pulumi.export("cloudSsoDirectoryId1", ids.directories[0].id)
     * name_regex = alicloud.cloudsso.get_directories(name_regex="^my-Directory")
     * pulumi.export("cloudSsoDirectoryId2", name_regex.directories[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetDirectories.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudSso.GetDirectories.Invoke(new()
     *     {
     *         NameRegex = "^my-Directory",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoDirectoryId1"] = ids&#46;Apply(getDirectoriesResult => getDirectoriesResult&#46;Directories[0]?.Id),
     *         ["cloudSsoDirectoryId2"] = nameRegex&#46;Apply(getDirectoriesResult => getDirectoriesResult&#46;Directories[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetDirectories(ctx, &cloudsso.GetDirectoriesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoDirectoryId1", ids.Directories[0].Id)
     * 		nameRegex, err := cloudsso.GetDirectories(ctx, &cloudsso.GetDirectoriesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Directory"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoDirectoryId2", nameRegex.Directories[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetDirectoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getDirectories(GetDirectoriesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("cloudSsoDirectoryId1", ids.applyValue(getDirectoriesResult -> getDirectoriesResult.directories()[0].id()));
     *         final var nameRegex = CloudssoFunctions.getDirectories(GetDirectoriesArgs.builder()
     *             .nameRegex("^my-Directory")
     *             .build());
     *         ctx.export("cloudSsoDirectoryId2", nameRegex.applyValue(getDirectoriesResult -> getDirectoriesResult.directories()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getDirectories
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getDirectories
     *       Arguments:
     *         nameRegex: ^my-Directory
     * outputs:
     *   cloudSsoDirectoryId1: ${ids.directories[0].id}
     *   cloudSsoDirectoryId2: ${nameRegex.directories[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDirectories.
     * @return A collection of values returned by getDirectories.
     */
    public suspend fun getDirectories(argument: GetDirectoriesPlainArgs): GetDirectoriesResult =
        getDirectoriesResultToKotlin(getDirectoriesPlain(argument.toJava()).await())

    /**
     * @see [getDirectories].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Directory IDs.
     * @param nameRegex A regex string to filter results by Directory name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDirectories.
     */
    public suspend fun getDirectories(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDirectoriesResult {
        val argument = GetDirectoriesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDirectoriesResultToKotlin(getDirectoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDirectories].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetDirectoriesPlainArgs].
     * @return A collection of values returned by getDirectories.
     */
    public suspend fun getDirectories(argument: suspend GetDirectoriesPlainArgsBuilder.() -> Unit): GetDirectoriesResult {
        val builder = GetDirectoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDirectoriesResultToKotlin(getDirectoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Sso Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getGroups({
     *     directoryId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudSsoGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.cloudsso.getGroups({
     *     directoryId: "example_value",
     *     nameRegex: "^my-Group",
     * });
     * export const cloudSsoGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_groups(directory_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudSsoGroupId1", ids.groups[0].id)
     * name_regex = alicloud.cloudsso.get_groups(directory_id="example_value",
     *     name_regex="^my-Group")
     * pulumi.export("cloudSsoGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetGroups.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudSso.GetGroups.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         NameRegex = "^my-Group",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoGroupId1"] = ids&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.Id),
     *         ["cloudSsoGroupId2"] = nameRegex&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetGroups(ctx, &cloudsso.GetGroupsArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := cloudsso.GetGroups(ctx, &cloudsso.GetGroupsArgs{
     * 			DirectoryId: "example_value",
     * 			NameRegex:   pulumi.StringRef("^my-Group"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getGroups(GetGroupsArgs.builder()
     *             .directoryId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudSsoGroupId1", ids.applyValue(getGroupsResult -> getGroupsResult.groups()[0].id()));
     *         final var nameRegex = CloudssoFunctions.getGroups(GetGroupsArgs.builder()
     *             .directoryId("example_value")
     *             .nameRegex("^my-Group")
     *             .build());
     *         ctx.export("cloudSsoGroupId2", nameRegex.applyValue(getGroupsResult -> getGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getGroups
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getGroups
     *       Arguments:
     *         directoryId: example_value
     *         nameRegex: ^my-Group
     * outputs:
     *   cloudSsoGroupId1: ${ids.groups[0].id}
     *   cloudSsoGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param directoryId The ID of the Directory.
     * @param ids A list of Group IDs.
     * @param nameRegex A regex string to filter results by Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param provisionType The ProvisionType of the Group. Valid values: `Manual`, `Synchronized`.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        directoryId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        provisionType: String? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            directoryId = directoryId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            provisionType = provisionType,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Sso Scim Server Credentials of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getScimServerCredentials({
     *     directoryId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudSsoScimServerCredentialId1 = ids.then(ids => ids.credentials?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_scim_server_credentials(directory_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudSsoScimServerCredentialId1", ids.credentials[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetScimServerCredentials.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoScimServerCredentialId1"] = ids&#46;Apply(getScimServerCredentialsResult => getScimServerCredentialsResult&#46;Credentials[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetScimServerCredentials(ctx, &cloudsso.GetScimServerCredentialsArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoScimServerCredentialId1", ids.Credentials[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetScimServerCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getScimServerCredentials(GetScimServerCredentialsArgs.builder()
     *             .directoryId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudSsoScimServerCredentialId1", ids.applyValue(getScimServerCredentialsResult -> getScimServerCredentialsResult.credentials()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getScimServerCredentials
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   cloudSsoScimServerCredentialId1: ${ids.credentials[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getScimServerCredentials.
     * @return A collection of values returned by getScimServerCredentials.
     */
    public suspend fun getScimServerCredentials(argument: GetScimServerCredentialsPlainArgs): GetScimServerCredentialsResult =
        getScimServerCredentialsResultToKotlin(getScimServerCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getScimServerCredentials].
     * @param directoryId The ID of the Directory.
     * @param ids A list of SCIM Server Credential IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The Status of the resource. Valid values: `Disabled`, `Enabled`.
     * @return A collection of values returned by getScimServerCredentials.
     */
    public suspend fun getScimServerCredentials(
        directoryId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetScimServerCredentialsResult {
        val argument = GetScimServerCredentialsPlainArgs(
            directoryId = directoryId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getScimServerCredentialsResultToKotlin(getScimServerCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getScimServerCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetScimServerCredentialsPlainArgs].
     * @return A collection of values returned by getScimServerCredentials.
     */
    public suspend fun getScimServerCredentials(argument: suspend GetScimServerCredentialsPlainArgsBuilder.() -> Unit): GetScimServerCredentialsResult {
        val builder = GetScimServerCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScimServerCredentialsResultToKotlin(getScimServerCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Cloud Sso Service automatically.
     * For information about Cloud SSO and how to use it, see [What is Cloud SSO](https://www.alibabacloud.com/help/en/doc-detail/262819.html).
     * > **NOTE:** Available in v1.148.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cloudsso.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cloudsso.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.CloudSso.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudsso.GetService(ctx, &cloudsso.GetServiceArgs{
     * 			Enable: "On",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CloudssoFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. Valid values: `On` or `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Cloud Sso service that means you have read and agreed the [Cloud Sso Terms of Service](https://help.aliyun.com/document_detail/299998.html). When there is no directory in Cloud SSO, you can set `enable = "Off"` to turn off Cloud SSO as needed. After it is closed, you can also open it at any time.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Sso Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudsso.getUsers({
     *     directoryId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudSsoUserId1 = ids.then(ids => ids.users?.[0]?.id);
     * const nameRegex = alicloud.cloudsso.getUsers({
     *     directoryId: "example_value",
     *     nameRegex: "^my-User",
     * });
     * export const cloudSsoUserId2 = nameRegex.then(nameRegex => nameRegex.users?.[0]?.id);
     * const provisionType = alicloud.cloudsso.getUsers({
     *     directoryId: "example_value",
     *     ids: ["example_value-1"],
     *     provisionType: "Manual",
     * });
     * export const cloudSsoUserId3 = provisionType.then(provisionType => provisionType.users?.[0]?.id);
     * const status = alicloud.cloudsso.getUsers({
     *     directoryId: "example_value",
     *     ids: ["example_value-1"],
     *     status: "Enabled",
     * });
     * export const cloudSsoUserId4 = status.then(status => status.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudsso.get_users(directory_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudSsoUserId1", ids.users[0].id)
     * name_regex = alicloud.cloudsso.get_users(directory_id="example_value",
     *     name_regex="^my-User")
     * pulumi.export("cloudSsoUserId2", name_regex.users[0].id)
     * provision_type = alicloud.cloudsso.get_users(directory_id="example_value",
     *     ids=["example_value-1"],
     *     provision_type="Manual")
     * pulumi.export("cloudSsoUserId3", provision_type.users[0].id)
     * status = alicloud.cloudsso.get_users(directory_id="example_value",
     *     ids=["example_value-1"],
     *     status="Enabled")
     * pulumi.export("cloudSsoUserId4", status.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudSso.GetUsers.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudSso.GetUsers.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         NameRegex = "^my-User",
     *     });
     *     var provisionType = AliCloud.CloudSso.GetUsers.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *         },
     *         ProvisionType = "Manual",
     *     });
     *     var status = AliCloud.CloudSso.GetUsers.Invoke(new()
     *     {
     *         DirectoryId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *         },
     *         Status = "Enabled",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudSsoUserId1"] = ids&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *         ["cloudSsoUserId2"] = nameRegex&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *         ["cloudSsoUserId3"] = provisionType&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *         ["cloudSsoUserId4"] = status&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudsso.GetUsers(ctx, &cloudsso.GetUsersArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoUserId1", ids.Users[0].Id)
     * 		nameRegex, err := cloudsso.GetUsers(ctx, &cloudsso.GetUsersArgs{
     * 			DirectoryId: "example_value",
     * 			NameRegex:   pulumi.StringRef("^my-User"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoUserId2", nameRegex.Users[0].Id)
     * 		provisionType, err := cloudsso.GetUsers(ctx, &cloudsso.GetUsersArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 			},
     * 			ProvisionType: pulumi.StringRef("Manual"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoUserId3", provisionType.Users[0].Id)
     * 		status, err := cloudsso.GetUsers(ctx, &cloudsso.GetUsersArgs{
     * 			DirectoryId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 			},
     * 			Status: pulumi.StringRef("Enabled"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudSsoUserId4", status.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
     * import com.pulumi.alicloud.cloudsso.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudssoFunctions.getUsers(GetUsersArgs.builder()
     *             .directoryId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudSsoUserId1", ids.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *         final var nameRegex = CloudssoFunctions.getUsers(GetUsersArgs.builder()
     *             .directoryId("example_value")
     *             .nameRegex("^my-User")
     *             .build());
     *         ctx.export("cloudSsoUserId2", nameRegex.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *         final var provisionType = CloudssoFunctions.getUsers(GetUsersArgs.builder()
     *             .directoryId("example_value")
     *             .ids("example_value-1")
     *             .provisionType("Manual")
     *             .build());
     *         ctx.export("cloudSsoUserId3", provisionType.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *         final var status = CloudssoFunctions.getUsers(GetUsersArgs.builder()
     *             .directoryId("example_value")
     *             .ids("example_value-1")
     *             .status("Enabled")
     *             .build());
     *         ctx.export("cloudSsoUserId4", status.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getUsers
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getUsers
     *       Arguments:
     *         directoryId: example_value
     *         nameRegex: ^my-User
     *   provisionType:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getUsers
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *         provisionType: Manual
     *   status:
     *     fn::invoke:
     *       Function: alicloud:cloudsso:getUsers
     *       Arguments:
     *         directoryId: example_value
     *         ids:
     *           - example_value-1
     *         status: Enabled
     * outputs:
     *   cloudSsoUserId1: ${ids.users[0].id}
     *   cloudSsoUserId2: ${nameRegex.users[0].id}
     *   cloudSsoUserId3: ${provisionType.users[0].id}
     *   cloudSsoUserId4: ${status.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param directoryId The ID of the Directory.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of User IDs.
     * @param nameRegex A regex string to filter results by User name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param provisionType ProvisionType. Valid values: `Manual`, `Synchronized`.
     * @param status The status of user. Valid values: `Disabled`, `Enabled`.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        directoryId: String,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        provisionType: String? = null,
        status: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            directoryId = directoryId,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            provisionType = provisionType,
            status = status,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudsso&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
