@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.kotlin.outputs.DirectorySamlIdentityProviderConfiguration
import com.pulumi.alicloud.cloudsso.kotlin.outputs.DirectorySamlIdentityProviderConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Directory].
 */
@PulumiTagMarker
public class DirectoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DirectoryArgs = DirectoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DirectoryArgsBuilder.() -> Unit) {
        val builder = DirectoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Directory {
        val builtJavaResource = com.pulumi.alicloud.cloudsso.Directory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Directory(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO Directory resource.
 * For information about Cloud SSO Directory and how to use it, see [What is Directory](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createdirectory).
 * > **NOTE:** Available since v1.135.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * export = async () => {
 *     const config = new pulumi.Config();
 *     const name = config.get("name") || "tf-example";
 *     const default = await alicloud.cloudsso.getDirectories({});
 *     const defaultDirectory: alicloud.cloudsso.Directory[] = [];
 *     for (const range = {value: 0}; range.value < (_default.ids.length > 0 ? 0 : 1); range.value++) {
 *         defaultDirectory.push(new alicloud.cloudsso.Directory(`default-${range.value}`, {directoryName: name}));
 *     }
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cloudsso.get_directories()
 * default_directory = []
 * for range in [{"value": i} for i in range(0, 0 if len(default&#46;ids) > 0 else 1)]:
 *     default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Threading.Tasks;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(async() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = await AliCloud.CloudSso.GetDirectories.InvokeAsync();
 *     var defaultDirectory = new List<AliCloud.CloudSso.Directory>();
 *     for (var rangeIndex = 0; rangeIndex < @default.Ids.Length > 0 ? 0 : 1; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultDirectory.Add(new AliCloud.CloudSso.Directory($"default-{range.Value}", new()
 *         {
 *             DirectoryName = name,
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := cloudsso.GetDirectories(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var tmp0 float64
 * 		if pulumi.Float64(len(_default.Ids)) > 0 {
 * 			tmp0 = 0
 * 		} else {
 * 			tmp0 = 1
 * 		}
 * 		var defaultDirectory []*cloudsso.Directory
 * 		for index := 0; index < tmp0; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := cloudsso.NewDirectory(ctx, fmt.Sprintf("default-%v", key0), &cloudsso.DirectoryArgs{
 * 				DirectoryName: pulumi.String(name),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultDirectory = append(defaultDirectory, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
 * import com.pulumi.alicloud.cloudsso.inputs.GetDirectoriesArgs;
 * import com.pulumi.alicloud.cloudsso.Directory;
 * import com.pulumi.alicloud.cloudsso.DirectoryArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = CloudssoFunctions.getDirectories();
 *         for (var i = 0; i < default_.ids().length() > 0 ? 0 : 1; i++) {
 *             new Directory("defaultDirectory-" + i, DirectoryArgs.builder()
 *                 .directoryName(name)
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultDirectory:
 *     type: alicloud:cloudsso:Directory
 *     name: default
 *     properties:
 *       directoryName: ${name}
 *     options: {}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cloudsso:getDirectories
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud SSO Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/directory:Directory example <id>
 * ```
 */
public class Directory internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.Directory,
) : KotlinCustomResource(javaResource, DirectoryMapper) {
    /**
     * The name of the CloudSSO directory. The length is 2-64 characters, and it can contain lowercase letters, numbers, and dashes (-). It cannot start or end with a dash and cannot have two consecutive dashes. Need to be globally unique, and capitalization is not supported. Cannot start with `d-`.
     */
    public val directoryName: Output<String>?
        get() = javaResource.directoryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Enabled`.
     */
    public val mfaAuthenticationStatus: Output<String>
        get() = javaResource.mfaAuthenticationStatus().applyValue({ args0 -> args0 })

    /**
     * The saml identity provider configuration. See `saml_identity_provider_configuration` below.
     * > **NOTE:** The `saml_identity_provider_configuration` will be removed automatically when the resource is deleted, please operate with caution. If there are left more configuration in the directory, please remove them before deleting the directory.
     */
    public val samlIdentityProviderConfiguration: Output<DirectorySamlIdentityProviderConfiguration>
        get() = javaResource.samlIdentityProviderConfiguration().applyValue({ args0 ->
            args0.let({ args0 -> toKotlin(args0) })
        })

    /**
     * The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
     */
    public val scimSynchronizationStatus: Output<String>
        get() = javaResource.scimSynchronizationStatus().applyValue({ args0 -> args0 })
}

public object DirectoryMapper : ResourceMapper<Directory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.Directory::class == javaResource::class

    override fun map(javaResource: Resource): Directory = Directory(
        javaResource as
            com.pulumi.alicloud.cloudsso.Directory,
    )
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Directory].
 */
public suspend fun directory(name: String, block: suspend DirectoryResourceBuilder.() -> Unit): Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun directory(name: String): Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
