@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.DirectoryArgs.builder
import com.pulumi.alicloud.cloudsso.kotlin.inputs.DirectorySamlIdentityProviderConfigurationArgs
import com.pulumi.alicloud.cloudsso.kotlin.inputs.DirectorySamlIdentityProviderConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO Directory resource.
 * For information about Cloud SSO Directory and how to use it, see [What is Directory](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createdirectory).
 * > **NOTE:** Available since v1.135.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * export = async () => {
 *     const config = new pulumi.Config();
 *     const name = config.get("name") || "tf-example";
 *     const default = await alicloud.cloudsso.getDirectories({});
 *     const defaultDirectory: alicloud.cloudsso.Directory[] = [];
 *     for (const range = {value: 0}; range.value < (_default.ids.length > 0 ? 0 : 1); range.value++) {
 *         defaultDirectory.push(new alicloud.cloudsso.Directory(`default-${range.value}`, {directoryName: name}));
 *     }
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cloudsso.get_directories()
 * default_directory = []
 * for range in [{"value": i} for i in range(0, 0 if len(default&#46;ids) > 0 else 1)]:
 *     default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Threading.Tasks;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(async() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = await AliCloud.CloudSso.GetDirectories.InvokeAsync();
 *     var defaultDirectory = new List<AliCloud.CloudSso.Directory>();
 *     for (var rangeIndex = 0; rangeIndex < @default.Ids.Length > 0 ? 0 : 1; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultDirectory.Add(new AliCloud.CloudSso.Directory($"default-{range.Value}", new()
 *         {
 *             DirectoryName = name,
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudsso"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := cloudsso.GetDirectories(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var tmp0 float64
 * 		if pulumi.Float64(len(_default.Ids)) > 0 {
 * 			tmp0 = 0
 * 		} else {
 * 			tmp0 = 1
 * 		}
 * 		var defaultDirectory []*cloudsso.Directory
 * 		for index := 0; index < tmp0; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := cloudsso.NewDirectory(ctx, fmt.Sprintf("default-%v", key0), &cloudsso.DirectoryArgs{
 * 				DirectoryName: pulumi.String(name),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultDirectory = append(defaultDirectory, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudsso.CloudssoFunctions;
 * import com.pulumi.alicloud.cloudsso.inputs.GetDirectoriesArgs;
 * import com.pulumi.alicloud.cloudsso.Directory;
 * import com.pulumi.alicloud.cloudsso.DirectoryArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = CloudssoFunctions.getDirectories();
 *         for (var i = 0; i < default_.ids().length() > 0 ? 0 : 1; i++) {
 *             new Directory("defaultDirectory-" + i, DirectoryArgs.builder()
 *                 .directoryName(name)
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultDirectory:
 *     type: alicloud:cloudsso:Directory
 *     name: default
 *     properties:
 *       directoryName: ${name}
 *     options: {}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cloudsso:getDirectories
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud SSO Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/directory:Directory example <id>
 * ```
 * @property directoryName The name of the CloudSSO directory. The length is 2-64 characters, and it can contain lowercase letters, numbers, and dashes (-). It cannot start or end with a dash and cannot have two consecutive dashes. Need to be globally unique, and capitalization is not supported. Cannot start with `d-`.
 * @property mfaAuthenticationStatus The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Enabled`.
 * @property samlIdentityProviderConfiguration The saml identity provider configuration. See `saml_identity_provider_configuration` below.
 * > **NOTE:** The `saml_identity_provider_configuration` will be removed automatically when the resource is deleted, please operate with caution. If there are left more configuration in the directory, please remove them before deleting the directory.
 * @property scimSynchronizationStatus The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 */
public data class DirectoryArgs(
    public val directoryName: Output<String>? = null,
    public val mfaAuthenticationStatus: Output<String>? = null,
    public val samlIdentityProviderConfiguration: Output<DirectorySamlIdentityProviderConfigurationArgs>? = null,
    public val scimSynchronizationStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.DirectoryArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.DirectoryArgs =
        com.pulumi.alicloud.cloudsso.DirectoryArgs.builder()
            .directoryName(directoryName?.applyValue({ args0 -> args0 }))
            .mfaAuthenticationStatus(mfaAuthenticationStatus?.applyValue({ args0 -> args0 }))
            .samlIdentityProviderConfiguration(
                samlIdentityProviderConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .scimSynchronizationStatus(scimSynchronizationStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryArgs].
 */
@PulumiTagMarker
public class DirectoryArgsBuilder internal constructor() {
    private var directoryName: Output<String>? = null

    private var mfaAuthenticationStatus: Output<String>? = null

    private var samlIdentityProviderConfiguration:
        Output<DirectorySamlIdentityProviderConfigurationArgs>? = null

    private var scimSynchronizationStatus: Output<String>? = null

    /**
     * @param value The name of the CloudSSO directory. The length is 2-64 characters, and it can contain lowercase letters, numbers, and dashes (-). It cannot start or end with a dash and cannot have two consecutive dashes. Need to be globally unique, and capitalization is not supported. Cannot start with `d-`.
     */
    @JvmName("hyvnjhjiinanlpwc")
    public suspend fun directoryName(`value`: Output<String>) {
        this.directoryName = value
    }

    /**
     * @param value The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Enabled`.
     */
    @JvmName("gxtgxxvwycyjooxl")
    public suspend fun mfaAuthenticationStatus(`value`: Output<String>) {
        this.mfaAuthenticationStatus = value
    }

    /**
     * @param value The saml identity provider configuration. See `saml_identity_provider_configuration` below.
     * > **NOTE:** The `saml_identity_provider_configuration` will be removed automatically when the resource is deleted, please operate with caution. If there are left more configuration in the directory, please remove them before deleting the directory.
     */
    @JvmName("aaqduemrmovyyqsq")
    public suspend fun samlIdentityProviderConfiguration(`value`: Output<DirectorySamlIdentityProviderConfigurationArgs>) {
        this.samlIdentityProviderConfiguration = value
    }

    /**
     * @param value The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
     */
    @JvmName("arhoauiipcqxcdgo")
    public suspend fun scimSynchronizationStatus(`value`: Output<String>) {
        this.scimSynchronizationStatus = value
    }

    /**
     * @param value The name of the CloudSSO directory. The length is 2-64 characters, and it can contain lowercase letters, numbers, and dashes (-). It cannot start or end with a dash and cannot have two consecutive dashes. Need to be globally unique, and capitalization is not supported. Cannot start with `d-`.
     */
    @JvmName("edsxohlxstfdwimj")
    public suspend fun directoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryName = mapped
    }

    /**
     * @param value The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Enabled`.
     */
    @JvmName("gthpwlvnapgprbae")
    public suspend fun mfaAuthenticationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaAuthenticationStatus = mapped
    }

    /**
     * @param value The saml identity provider configuration. See `saml_identity_provider_configuration` below.
     * > **NOTE:** The `saml_identity_provider_configuration` will be removed automatically when the resource is deleted, please operate with caution. If there are left more configuration in the directory, please remove them before deleting the directory.
     */
    @JvmName("byigmetxdsdfilpe")
    public suspend fun samlIdentityProviderConfiguration(`value`: DirectorySamlIdentityProviderConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlIdentityProviderConfiguration = mapped
    }

    /**
     * @param argument The saml identity provider configuration. See `saml_identity_provider_configuration` below.
     * > **NOTE:** The `saml_identity_provider_configuration` will be removed automatically when the resource is deleted, please operate with caution. If there are left more configuration in the directory, please remove them before deleting the directory.
     */
    @JvmName("ildmfylbahfoxdkj")
    public suspend fun samlIdentityProviderConfiguration(argument: suspend DirectorySamlIdentityProviderConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DirectorySamlIdentityProviderConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.samlIdentityProviderConfiguration = mapped
    }

    /**
     * @param value The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
     */
    @JvmName("kgagnjharigykpua")
    public suspend fun scimSynchronizationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scimSynchronizationStatus = mapped
    }

    internal fun build(): DirectoryArgs = DirectoryArgs(
        directoryName = directoryName,
        mfaAuthenticationStatus = mfaAuthenticationStatus,
        samlIdentityProviderConfiguration = samlIdentityProviderConfiguration,
        scimSynchronizationStatus = scimSynchronizationStatus,
    )
}
