@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.alicloud.cloudsso.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO Group resource.
 * For information about Cloud SSO Group and how to use it, see [What is Group](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-creategroup).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * Cloud SSO Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/group:Group example <directory_id>:<group_id>
 * ```
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * The Description of the group. The description can be up to `1024` characters long.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The GroupId of the group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The Name of the group. The name must be `1` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(
        javaResource as
            com.pulumi.alicloud.cloudsso.Group,
    )
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
