@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO Group resource.
 * For information about Cloud SSO Group and how to use it, see [What is Group](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-creategroup).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * Cloud SSO Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/group:Group example <directory_id>:<group_id>
 * ```
 * @property description The Description of the group. The description can be up to `1024` characters long.
 * @property directoryId The ID of the Directory.
 * @property groupName The Name of the group. The name must be `1` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val groupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.GroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.GroupArgs =
        com.pulumi.alicloud.cloudsso.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value The Description of the group. The description can be up to `1024` characters long.
     */
    @JvmName("iuykbmrivaiinyct")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("dnirooegncxxljkc")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The Name of the group. The name must be `1` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("rftracqqcoarkqxb")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The Description of the group. The description can be up to `1024` characters long.
     */
    @JvmName("ebdwejamjhdgwayw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("nhmexybkufovfhth")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The Name of the group. The name must be `1` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("ljyebjeeenlwbbfa")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        directoryId = directoryId,
        groupName = groupName,
    )
}
