@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScimServerCredential].
 */
@PulumiTagMarker
public class ScimServerCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScimServerCredentialArgs = ScimServerCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScimServerCredentialArgsBuilder.() -> Unit) {
        val builder = ScimServerCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScimServerCredential {
        val builtJavaResource =
            com.pulumi.alicloud.cloudsso.ScimServerCredential(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScimServerCredential(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO SCIM Server Credential resource.
 * For information about Cloud SSO SCIM Server Credential and how to use it, see [What is Cloud SSO SCIM Server Credential](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createscimservercredential).
 * > **NOTE:** Available since v1.138.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO SCIM Server Credential can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/scimServerCredential:ScimServerCredential example <directory_id>:<credential_id>
 * ```
 */
public class ScimServerCredential internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.ScimServerCredential,
) : KotlinCustomResource(javaResource, ScimServerCredentialMapper) {
    /**
     * The CredentialId of the resource.
     */
    public val credentialId: Output<String>
        get() = javaResource.credentialId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The Status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ScimServerCredentialMapper : ResourceMapper<ScimServerCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.ScimServerCredential::class == javaResource::class

    override fun map(javaResource: Resource): ScimServerCredential = ScimServerCredential(
        javaResource
            as com.pulumi.alicloud.cloudsso.ScimServerCredential,
    )
}

/**
 * @see [ScimServerCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScimServerCredential].
 */
public suspend fun scimServerCredential(
    name: String,
    block: suspend ScimServerCredentialResourceBuilder.() -> Unit,
): ScimServerCredential {
    val builder = ScimServerCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScimServerCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scimServerCredential(name: String): ScimServerCredential {
    val builder = ScimServerCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
